<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the ExternalCallerHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ExternalCallerHeader $externalCallerHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderExternalCallerHeader(\StructType\ExternalCallerHeader $externalCallerHeader, $nameSpace = 'http://www.i-label.net/Partners/WebServices/DataFeed/2005/11', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ExternalCallerHeader', $externalCallerHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetUnsentProductData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ExternalCallerHeader
     * - SOAPHeaderNamespaces: http://www.i-label.net/Partners/WebServices/DataFeed/2005/11
     * - SOAPHeaderTypes: \StructType\ExternalCallerHeader
     * - SOAPHeaders: required
     * - documentation: Return xml data for all products not yet downloaded
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnsentProductData $parameters
     * @return \StructType\GetUnsentProductDataResponse|bool
     */
    public function GetUnsentProductData(\StructType\GetUnsentProductData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUnsentProductData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductDataForGTINs
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ExternalCallerHeader
     * - SOAPHeaderNamespaces: http://www.i-label.net/Partners/WebServices/DataFeed/2005/11
     * - SOAPHeaderTypes: \StructType\ExternalCallerHeader
     * - SOAPHeaders: required
     * - documentation: Return xml data for specific products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductDataForGTINs $parameters
     * @return \StructType\GetProductDataForGTINsResponse|bool
     */
    public function GetProductDataForGTINs(\StructType\GetProductDataForGTINs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductDataForGTINs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetProductDataForGTINsResponse|\StructType\GetUnsentProductDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
