<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.brandbank.com/svc/feed/extractdata.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.brandbank.com/svc/feed/extractdata.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderExternalCallerHeader(new \StructType\ExternalCallerHeader());
/**
 * Sample call for GetUnsentProductData operation/method
 */
if ($get->GetUnsentProductData(new \StructType\GetUnsentProductData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductDataForGTINs operation/method
 */
if ($get->GetProductDataForGTINs(new \StructType\GetProductDataForGTINs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Acknowledge ServiceType
 */
$acknowledge = new \ServiceType\Acknowledge($options);
$acknowledge->setSoapHeaderExternalCallerHeader(new \StructType\ExternalCallerHeader());
/**
 * Sample call for AcknowledgeMessage operation/method
 */
if ($acknowledge->AcknowledgeMessage(new \StructType\AcknowledgeMessage()) !== false) {
    print_r($acknowledge->getResult());
} else {
    print_r($acknowledge->getLastError());
}
