<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalCallerHeader StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ExternalCallerHeader
 * @subpackage Structs
 */
class ExternalCallerHeader extends AbstractStructBase
{
    /**
     * The ExternalCallerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ExternalCallerId;
    /**
     * Constructor method for ExternalCallerHeader
     * @uses ExternalCallerHeader::setExternalCallerId()
     * @param string $externalCallerId
     */
    public function __construct($externalCallerId = null)
    {
        $this
            ->setExternalCallerId($externalCallerId);
    }
    /**
     * Get ExternalCallerId value
     * @return string
     */
    public function getExternalCallerId()
    {
        return $this->ExternalCallerId;
    }
    /**
     * Set ExternalCallerId value
     * @param string $externalCallerId
     * @return \StructType\ExternalCallerHeader
     */
    public function setExternalCallerId($externalCallerId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($externalCallerId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $externalCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($externalCallerId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalCallerId) && !is_string($externalCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalCallerId)), __LINE__);
        }
        $this->ExternalCallerId = $externalCallerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalCallerHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
