<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Acknowledge ServiceType
 * @subpackage Services
 */
class Acknowledge extends AbstractSoapClientBase
{
    /**
     * Sets the ExternalCallerHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ExternalCallerHeader $externalCallerHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderExternalCallerHeader(\StructType\ExternalCallerHeader $externalCallerHeader, $nameSpace = 'http://www.i-label.net/Partners/WebServices/DataFeed/2005/11', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ExternalCallerHeader', $externalCallerHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AcknowledgeMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ExternalCallerHeader
     * - SOAPHeaderNamespaces: http://www.i-label.net/Partners/WebServices/DataFeed/2005/11
     * - SOAPHeaderTypes: \StructType\ExternalCallerHeader
     * - SOAPHeaders: required
     * - documentation: Acknowledge the receipt of a message
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AcknowledgeMessage $parameters
     * @return \StructType\AcknowledgeMessageResponse|bool
     */
    public function AcknowledgeMessage(\StructType\AcknowledgeMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AcknowledgeMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AcknowledgeMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
