<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the UserSessionCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\UserSessionCredentials $userSessionCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserSessionCredentials(\StructType\UserSessionCredentials $userSessionCredentials, $nameSpace = 'http://www.peoplevox.net/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserSessionCredentials', $userSessionCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : UserSessionCredentials
     * - SOAPHeaderNamespaces : http://www.peoplevox.net/
     * - SOAPHeaderTypes : \StructType\UserSessionCredentials
     * - SOAPHeaders : required
     * - documentation: Export data from the PeopleVox system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetData $parameters
     * @return \StructType\GetDataResponse|bool
     */
    public function GetData(\StructType\GetData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemSettings
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : UserSessionCredentials
     * - SOAPHeaderNamespaces : http://www.peoplevox.net/
     * - SOAPHeaderTypes : \StructType\UserSessionCredentials
     * - SOAPHeaders : required
     * - documentation: Export settings from PeopleVox system. | Export settings from PeopleVox system. | Export settings from PeopleVox system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSystemSettings $parameters
     * @return \StructType\GetSystemSettingsResponse|bool
     */
    public function GetSystemSettings(\StructType\GetSystemSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSystemSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReportData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : UserSessionCredentials
     * - SOAPHeaderNamespaces : http://www.peoplevox.net/
     * - SOAPHeaderTypes : \StructType\UserSessionCredentials
     * - SOAPHeaders : required
     * - documentation: Export reports data from the PeopleVox system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReportData $parameters
     * @return \StructType\GetReportDataResponse|bool
     */
    public function GetReportData(\StructType\GetReportData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReportData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReportColumns
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : UserSessionCredentials
     * - SOAPHeaderNamespaces : http://www.peoplevox.net/
     * - SOAPHeaderTypes : \StructType\UserSessionCredentials
     * - SOAPHeaders : required
     * - documentation: Returns the list of columns of a report. | Returns the list of columns of a report. | Returns the list of columns of a report.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReportColumns $parameters
     * @return \StructType\GetReportColumnsResponse|bool
     */
    public function GetReportColumns(\StructType\GetReportColumns $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReportColumns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSaveTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : UserSessionCredentials
     * - SOAPHeaderNamespaces : http://www.peoplevox.net/
     * - SOAPHeaderTypes : \StructType\UserSessionCredentials
     * - SOAPHeaders : required
     * - documentation: Returns the csv template for saving informations. | Returns the csv template for saving informations. | Returns the csv template for saving informations.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaveTemplate $parameters
     * @return \StructType\GetSaveTemplateResponse|bool
     */
    public function GetSaveTemplate(\StructType\GetSaveTemplate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSaveTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDataResponse|\StructType\GetReportColumnsResponse|\StructType\GetReportDataResponse|\StructType\GetSaveTemplateResponse|\StructType\GetSystemSettingsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
