<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRequest StructType
 * @subpackage Structs
 */
class GetRequest extends AbstractStructBase
{
    /**
     * The PageNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageNo;
    /**
     * The ItemsPerPage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemsPerPage;
    /**
     * The TemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateName;
    /**
     * The SearchClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchClause;
    /**
     * Constructor method for GetRequest
     * @uses GetRequest::setPageNo()
     * @uses GetRequest::setItemsPerPage()
     * @uses GetRequest::setTemplateName()
     * @uses GetRequest::setSearchClause()
     * @param int $pageNo
     * @param int $itemsPerPage
     * @param string $templateName
     * @param string $searchClause
     */
    public function __construct($pageNo = null, $itemsPerPage = null, $templateName = null, $searchClause = null)
    {
        $this
            ->setPageNo($pageNo)
            ->setItemsPerPage($itemsPerPage)
            ->setTemplateName($templateName)
            ->setSearchClause($searchClause);
    }
    /**
     * Get PageNo value
     * @return int
     */
    public function getPageNo()
    {
        return $this->PageNo;
    }
    /**
     * Set PageNo value
     * @param int $pageNo
     * @return \StructType\GetRequest
     */
    public function setPageNo($pageNo = null)
    {
        // validation for constraint: int
        if (!is_null($pageNo) && !is_numeric($pageNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageNo)), __LINE__);
        }
        $this->PageNo = $pageNo;
        return $this;
    }
    /**
     * Get ItemsPerPage value
     * @return int
     */
    public function getItemsPerPage()
    {
        return $this->ItemsPerPage;
    }
    /**
     * Set ItemsPerPage value
     * @param int $itemsPerPage
     * @return \StructType\GetRequest
     */
    public function setItemsPerPage($itemsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($itemsPerPage) && !is_numeric($itemsPerPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemsPerPage)), __LINE__);
        }
        $this->ItemsPerPage = $itemsPerPage;
        return $this;
    }
    /**
     * Get TemplateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->TemplateName;
    }
    /**
     * Set TemplateName value
     * @param string $templateName
     * @return \StructType\GetRequest
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateName)), __LINE__);
        }
        $this->TemplateName = $templateName;
        return $this;
    }
    /**
     * Get SearchClause value
     * @return string|null
     */
    public function getSearchClause()
    {
        return $this->SearchClause;
    }
    /**
     * Set SearchClause value
     * @param string $searchClause
     * @return \StructType\GetRequest
     */
    public function setSearchClause($searchClause = null)
    {
        // validation for constraint: string
        if (!is_null($searchClause) && !is_string($searchClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchClause)), __LINE__);
        }
        $this->SearchClause = $searchClause;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
