<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcel StructType
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The consignmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $consignmentNumber;
    /**
     * The dropOffPoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DropOffPoint
     */
    public $dropOffPoint;
    /**
     * The events
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Event
     */
    public $events;
    /**
     * The hazardousMaterial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hazardousMaterial;
    /**
     * The longStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $longStatus;
    /**
     * The primaryPODUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $primaryPODUrl;
    /**
     * The receiver
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FullAddress
     */
    public $receiver;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The secondaryPODUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secondaryPODUrl;
    /**
     * The sender
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FullAddress
     */
    public $sender;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The shortStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shortStatus;
    /**
     * The statusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusCode;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * Constructor method for parcel
     * @uses Parcel::setAccountNumber()
     * @uses Parcel::setConsignmentNumber()
     * @uses Parcel::setDropOffPoint()
     * @uses Parcel::setEvents()
     * @uses Parcel::setHazardousMaterial()
     * @uses Parcel::setLongStatus()
     * @uses Parcel::setPrimaryPODUrl()
     * @uses Parcel::setReceiver()
     * @uses Parcel::setReference()
     * @uses Parcel::setSecondaryPODUrl()
     * @uses Parcel::setSender()
     * @uses Parcel::setService()
     * @uses Parcel::setShortStatus()
     * @uses Parcel::setStatusCode()
     * @uses Parcel::setWeight()
     * @param string $accountNumber
     * @param string $consignmentNumber
     * @param \StructType\DropOffPoint $dropOffPoint
     * @param \StructType\Event $events
     * @param string $hazardousMaterial
     * @param string[] $longStatus
     * @param string $primaryPODUrl
     * @param \StructType\FullAddress $receiver
     * @param string $reference
     * @param string $secondaryPODUrl
     * @param \StructType\FullAddress $sender
     * @param string $service
     * @param string $shortStatus
     * @param string $statusCode
     * @param float $weight
     */
    public function __construct($accountNumber = null, $consignmentNumber = null, \StructType\DropOffPoint $dropOffPoint = null, \StructType\Event $events = null, $hazardousMaterial = null, array $longStatus = array(), $primaryPODUrl = null, \StructType\FullAddress $receiver = null, $reference = null, $secondaryPODUrl = null, \StructType\FullAddress $sender = null, $service = null, $shortStatus = null, $statusCode = null, $weight = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setConsignmentNumber($consignmentNumber)
            ->setDropOffPoint($dropOffPoint)
            ->setEvents($events)
            ->setHazardousMaterial($hazardousMaterial)
            ->setLongStatus($longStatus)
            ->setPrimaryPODUrl($primaryPODUrl)
            ->setReceiver($receiver)
            ->setReference($reference)
            ->setSecondaryPODUrl($secondaryPODUrl)
            ->setSender($sender)
            ->setService($service)
            ->setShortStatus($shortStatus)
            ->setStatusCode($statusCode)
            ->setWeight($weight);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\Parcel
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get consignmentNumber value
     * @return string|null
     */
    public function getConsignmentNumber()
    {
        return $this->consignmentNumber;
    }
    /**
     * Set consignmentNumber value
     * @param string $consignmentNumber
     * @return \StructType\Parcel
     */
    public function setConsignmentNumber($consignmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNumber) && !is_string($consignmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentNumber)), __LINE__);
        }
        $this->consignmentNumber = $consignmentNumber;
        return $this;
    }
    /**
     * Get dropOffPoint value
     * @return \StructType\DropOffPoint|null
     */
    public function getDropOffPoint()
    {
        return $this->dropOffPoint;
    }
    /**
     * Set dropOffPoint value
     * @param \StructType\DropOffPoint $dropOffPoint
     * @return \StructType\Parcel
     */
    public function setDropOffPoint(\StructType\DropOffPoint $dropOffPoint = null)
    {
        $this->dropOffPoint = $dropOffPoint;
        return $this;
    }
    /**
     * Get events value
     * @return \StructType\Event|null
     */
    public function getEvents()
    {
        return $this->events;
    }
    /**
     * Set events value
     * @param \StructType\Event $events
     * @return \StructType\Parcel
     */
    public function setEvents(\StructType\Event $events = null)
    {
        $this->events = $events;
        return $this;
    }
    /**
     * Get hazardousMaterial value
     * @return string|null
     */
    public function getHazardousMaterial()
    {
        return $this->hazardousMaterial;
    }
    /**
     * Set hazardousMaterial value
     * @uses \EnumType\TypeMatiereDangereuse::valueIsValid()
     * @uses \EnumType\TypeMatiereDangereuse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hazardousMaterial
     * @return \StructType\Parcel
     */
    public function setHazardousMaterial($hazardousMaterial = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeMatiereDangereuse::valueIsValid($hazardousMaterial)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hazardousMaterial, implode(', ', \EnumType\TypeMatiereDangereuse::getValidValues())), __LINE__);
        }
        $this->hazardousMaterial = $hazardousMaterial;
        return $this;
    }
    /**
     * Get longStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLongStatus()
    {
        return isset($this->longStatus) ? $this->longStatus : null;
    }
    /**
     * Set longStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $longStatus
     * @return \StructType\Parcel
     */
    public function setLongStatus(array $longStatus = array())
    {
        foreach ($longStatus as $parcelLongStatusItem) {
            // validation for constraint: itemType
            if (!is_string($parcelLongStatusItem)) {
                throw new \InvalidArgumentException(sprintf('The longStatus property can only contain items of string, "%s" given', is_object($parcelLongStatusItem) ? get_class($parcelLongStatusItem) : gettype($parcelLongStatusItem)), __LINE__);
            }
        }
        if (is_null($longStatus) || (is_array($longStatus) && empty($longStatus))) {
            unset($this->longStatus);
        } else {
            $this->longStatus = $longStatus;
        }
        return $this;
    }
    /**
     * Add item to longStatus value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Parcel
     */
    public function addToLongStatus($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The longStatus property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->longStatus[] = $item;
        return $this;
    }
    /**
     * Get primaryPODUrl value
     * @return string|null
     */
    public function getPrimaryPODUrl()
    {
        return $this->primaryPODUrl;
    }
    /**
     * Set primaryPODUrl value
     * @param string $primaryPODUrl
     * @return \StructType\Parcel
     */
    public function setPrimaryPODUrl($primaryPODUrl = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPODUrl) && !is_string($primaryPODUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryPODUrl)), __LINE__);
        }
        $this->primaryPODUrl = $primaryPODUrl;
        return $this;
    }
    /**
     * Get receiver value
     * @return \StructType\FullAddress|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param \StructType\FullAddress $receiver
     * @return \StructType\Parcel
     */
    public function setReceiver(\StructType\FullAddress $receiver = null)
    {
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\Parcel
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get secondaryPODUrl value
     * @return string|null
     */
    public function getSecondaryPODUrl()
    {
        return $this->secondaryPODUrl;
    }
    /**
     * Set secondaryPODUrl value
     * @param string $secondaryPODUrl
     * @return \StructType\Parcel
     */
    public function setSecondaryPODUrl($secondaryPODUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryPODUrl) && !is_string($secondaryPODUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryPODUrl)), __LINE__);
        }
        $this->secondaryPODUrl = $secondaryPODUrl;
        return $this;
    }
    /**
     * Get sender value
     * @return \StructType\FullAddress|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \StructType\FullAddress $sender
     * @return \StructType\Parcel
     */
    public function setSender(\StructType\FullAddress $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\Parcel
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get shortStatus value
     * @return string|null
     */
    public function getShortStatus()
    {
        return $this->shortStatus;
    }
    /**
     * Set shortStatus value
     * @param string $shortStatus
     * @return \StructType\Parcel
     */
    public function setShortStatus($shortStatus = null)
    {
        // validation for constraint: string
        if (!is_null($shortStatus) && !is_string($shortStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortStatus)), __LINE__);
        }
        $this->shortStatus = $shortStatus;
        return $this;
    }
    /**
     * Get statusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param string $statusCode
     * @return \StructType\Parcel
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\Parcel
     */
    public function setWeight($weight = null)
    {
        $this->weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Parcel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
