<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dropOffPoint StructType
 * @subpackage Structs
 */
class DropOffPoint extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The deliveryFlag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryFlag;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The zipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The xETTCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $xETTCode;
    /**
     * Constructor method for dropOffPoint
     * @uses DropOffPoint::setAddress()
     * @uses DropOffPoint::setCity()
     * @uses DropOffPoint::setDeliveryFlag()
     * @uses DropOffPoint::setName()
     * @uses DropOffPoint::setZipCode()
     * @uses DropOffPoint::setXETTCode()
     * @param string $address
     * @param string $city
     * @param string $deliveryFlag
     * @param string $name
     * @param string $zipCode
     * @param string $xETTCode
     */
    public function __construct($address = null, $city = null, $deliveryFlag = null, $name = null, $zipCode = null, $xETTCode = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setDeliveryFlag($deliveryFlag)
            ->setName($name)
            ->setZipCode($zipCode)
            ->setXETTCode($xETTCode);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\DropOffPoint
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\DropOffPoint
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get deliveryFlag value
     * @return string|null
     */
    public function getDeliveryFlag()
    {
        return $this->deliveryFlag;
    }
    /**
     * Set deliveryFlag value
     * @param string $deliveryFlag
     * @return \StructType\DropOffPoint
     */
    public function setDeliveryFlag($deliveryFlag = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryFlag) && !is_string($deliveryFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryFlag)), __LINE__);
        }
        $this->deliveryFlag = $deliveryFlag;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DropOffPoint
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\DropOffPoint
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get xETTCode value
     * @return string|null
     */
    public function getXETTCode()
    {
        return $this->xETTCode;
    }
    /**
     * Set xETTCode value
     * @param string $xETTCode
     * @return \StructType\DropOffPoint
     */
    public function setXETTCode($xETTCode = null)
    {
        // validation for constraint: string
        if (!is_null($xETTCode) && !is_string($xETTCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($xETTCode)), __LINE__);
        }
        $this->xETTCode = $xETTCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DropOffPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
