<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.tnt.fr/service/tracking?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.tnt.fr/service/tracking?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Tracking ServiceType
 */
$tracking = new \ServiceType\Tracking($options);
/**
 * Sample call for trackingByConsignment operation/method
 */
if ($tracking->trackingByConsignment(new \StructType\TrackingByConsignment()) !== false) {
    print_r($tracking->getResult());
} else {
    print_r($tracking->getLastError());
}
/**
 * Samples for Contact ServiceType
 */
$contact = new \ServiceType\Contact($options);
/**
 * Sample call for contactRequest operation/method
 */
if ($contact->contactRequest(new \StructType\ContactRequest()) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Sample call for contactInterRequest operation/method
 */
if ($contact->contactInterRequest(new \StructType\ContactInterRequest()) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
