<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tracking ServiceType
 * @subpackage Services
 */
class Tracking extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named trackingByConsignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TrackingByConsignment $parameters
     * @return \StructType\TrackingByConsignmentResponse|bool
     */
    public function trackingByConsignment(\StructType\TrackingByConsignment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->trackingByConsignment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TrackingByConsignmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
