<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Contact ServiceType
 * @subpackage Services
 */
class Contact extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named contactRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContactRequest $parameters
     * @return \StructType\ContactRequestResponse|bool
     */
    public function contactRequest(\StructType\ContactRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->contactRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactInterRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContactInterRequest $parameters
     * @return \StructType\ContactInterRequestResponse|bool
     */
    public function contactInterRequest(\StructType\ContactInterRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->contactInterRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ContactInterRequestResponse|\StructType\ContactRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
