<?php

namespace EnumType;

/**
 * This class stands for typeMatiereDangereuse EnumType
 * @subpackage Enumerations
 */
class TypeMatiereDangereuse
{
    /**
     * Constant for value 'EQ'
     * @return string 'EQ'
     */
    const VALUE_EQ = 'EQ';
    /**
     * Constant for value 'LQ'
     * @return string 'LQ'
     */
    const VALUE_LQ = 'LQ';
    /**
     * Constant for value 'BB'
     * @return string 'BB'
     */
    const VALUE_BB = 'BB';
    /**
     * Constant for value 'GM'
     * @return string 'GM'
     */
    const VALUE_GM = 'GM';
    /**
     * Constant for value 'LB'
     * @return string 'LB'
     */
    const VALUE_LB = 'LB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQ
     * @uses self::VALUE_LQ
     * @uses self::VALUE_BB
     * @uses self::VALUE_GM
     * @uses self::VALUE_LB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQ,
            self::VALUE_LQ,
            self::VALUE_BB,
            self::VALUE_GM,
            self::VALUE_LB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
