<?php

namespace EnumType;

/**
 * This class stands for contactType EnumType
 * @subpackage Enumerations
 */
class ContactType
{
    /**
     * Constant for value 'IPHONE'
     * @return string 'IPHONE'
     */
    const VALUE_IPHONE = 'IPHONE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IPHONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IPHONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
