<?php

namespace EnumType;

/**
 * This class stands for civilite EnumType
 * @subpackage Enumerations
 */
class Civilite
{
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Constant for value 'MRS'
     * @return string 'MRS'
     */
    const VALUE_MRS = 'MRS';
    /**
     * Constant for value 'MS'
     * @return string 'MS'
     */
    const VALUE_MS = 'MS';
    /**
     * Constant for value 'MR'
     * @return string 'MR'
     */
    const VALUE_MR = 'MR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_MRS
     * @uses self::VALUE_MS
     * @uses self::VALUE_MR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_MRS,
            self::VALUE_MS,
            self::VALUE_MR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
