<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contactRequestParameter StructType
 * @subpackage Structs
 */
class ContactRequestParameter extends AutoValidatedInput
{
    /**
     * The contactFirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactFirstName;
    /**
     * The contactLastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactLastName;
    /**
     * The contactTitle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactTitle;
    /**
     * The emailAdress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailAdress;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The parcelNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parcelNumber;
    /**
     * The phoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestType;
    /**
     * Constructor method for contactRequestParameter
     * @uses ContactRequestParameter::setContactFirstName()
     * @uses ContactRequestParameter::setContactLastName()
     * @uses ContactRequestParameter::setContactTitle()
     * @uses ContactRequestParameter::setEmailAdress()
     * @uses ContactRequestParameter::setMessage()
     * @uses ContactRequestParameter::setParcelNumber()
     * @uses ContactRequestParameter::setPhoneNumber()
     * @uses ContactRequestParameter::setRequestType()
     * @param string $contactFirstName
     * @param string $contactLastName
     * @param string $contactTitle
     * @param string $emailAdress
     * @param string $message
     * @param string $parcelNumber
     * @param string $phoneNumber
     * @param string $requestType
     */
    public function __construct($contactFirstName = null, $contactLastName = null, $contactTitle = null, $emailAdress = null, $message = null, $parcelNumber = null, $phoneNumber = null, $requestType = null)
    {
        $this
            ->setContactFirstName($contactFirstName)
            ->setContactLastName($contactLastName)
            ->setContactTitle($contactTitle)
            ->setEmailAdress($emailAdress)
            ->setMessage($message)
            ->setParcelNumber($parcelNumber)
            ->setPhoneNumber($phoneNumber)
            ->setRequestType($requestType);
    }
    /**
     * Get contactFirstName value
     * @return string|null
     */
    public function getContactFirstName()
    {
        return $this->contactFirstName;
    }
    /**
     * Set contactFirstName value
     * @param string $contactFirstName
     * @return \StructType\ContactRequestParameter
     */
    public function setContactFirstName($contactFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($contactFirstName) && !is_string($contactFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactFirstName)), __LINE__);
        }
        $this->contactFirstName = $contactFirstName;
        return $this;
    }
    /**
     * Get contactLastName value
     * @return string|null
     */
    public function getContactLastName()
    {
        return $this->contactLastName;
    }
    /**
     * Set contactLastName value
     * @param string $contactLastName
     * @return \StructType\ContactRequestParameter
     */
    public function setContactLastName($contactLastName = null)
    {
        // validation for constraint: string
        if (!is_null($contactLastName) && !is_string($contactLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactLastName)), __LINE__);
        }
        $this->contactLastName = $contactLastName;
        return $this;
    }
    /**
     * Get contactTitle value
     * @return string|null
     */
    public function getContactTitle()
    {
        return $this->contactTitle;
    }
    /**
     * Set contactTitle value
     * @uses \EnumType\Civilite::valueIsValid()
     * @uses \EnumType\Civilite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactTitle
     * @return \StructType\ContactRequestParameter
     */
    public function setContactTitle($contactTitle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Civilite::valueIsValid($contactTitle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contactTitle, implode(', ', \EnumType\Civilite::getValidValues())), __LINE__);
        }
        $this->contactTitle = $contactTitle;
        return $this;
    }
    /**
     * Get emailAdress value
     * @return string|null
     */
    public function getEmailAdress()
    {
        return $this->emailAdress;
    }
    /**
     * Set emailAdress value
     * @param string $emailAdress
     * @return \StructType\ContactRequestParameter
     */
    public function setEmailAdress($emailAdress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAdress) && !is_string($emailAdress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAdress)), __LINE__);
        }
        $this->emailAdress = $emailAdress;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ContactRequestParameter
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get parcelNumber value
     * @return string|null
     */
    public function getParcelNumber()
    {
        return $this->parcelNumber;
    }
    /**
     * Set parcelNumber value
     * @param string $parcelNumber
     * @return \StructType\ContactRequestParameter
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelNumber) && !is_string($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelNumber)), __LINE__);
        }
        $this->parcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \StructType\ContactRequestParameter
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @uses \EnumType\ContactType::valueIsValid()
     * @uses \EnumType\ContactType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \StructType\ContactRequestParameter
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \EnumType\ContactType::getValidValues())), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactRequestParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
