<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webtrace.dpd.fr/dpd-webservices/webtrace_service.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webtrace.dpd.fr/dpd-webservices/webtrace_service.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getShipmentTrace operation/method
 */
if ($get->getShipmentTrace(new \StructType\GetShipmentTrace()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceAsArray operation/method
 */
if ($get->getShipmentTraceAsArray(new \StructType\GetShipmentTraceAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByLanguageAsArray operation/method
 */
if ($get->getShipmentTraceByLanguageAsArray(new \StructType\GetShipmentTraceByLanguageAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceWithImages operation/method
 */
if ($get->getShipmentTraceWithImages(new \StructType\GetShipmentTraceWithImages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReference operation/method
 */
if ($get->getShipmentTraceByReference(new \StructType\GetShipmentTraceByReference()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceAsArray operation/method
 */
if ($get->getShipmentTraceByReferenceAsArray(new \StructType\GetShipmentTraceByReferenceAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceAndLanguageAsArray operation/method
 */
if ($get->getShipmentTraceByReferenceAndLanguageAsArray(new \StructType\GetShipmentTraceByReferenceAndLanguageAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceWithImages operation/method
 */
if ($get->getShipmentTraceByReferenceWithImages(new \StructType\GetShipmentTraceByReferenceWithImages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceGlobal operation/method
 */
if ($get->getShipmentTraceByReferenceGlobal(new \StructType\GetShipmentTraceByReferenceGlobal()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceGlobalAsArray operation/method
 */
if ($get->getShipmentTraceByReferenceGlobalAsArray(new \StructType\GetShipmentTraceByReferenceGlobalAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceGlobalWithCenterAsArray
 * operation/method
 */
if ($get->getShipmentTraceByReferenceGlobalWithCenterAsArray(new \StructType\GetShipmentTraceByReferenceGlobalWithCenterAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceAndLanguageGlobalAsArray
 * operation/method
 */
if ($get->getShipmentTraceByReferenceAndLanguageGlobalAsArray(new \StructType\GetShipmentTraceByReferenceAndLanguageGlobalAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByReferenceGlobalWithImages operation/method
 */
if ($get->getShipmentTraceByReferenceGlobalWithImages(new \StructType\GetShipmentTraceByReferenceGlobalWithImages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipmentTraceByDPDReferenceGlobalAsArray operation/method
 */
if ($get->getShipmentTraceByDPDReferenceGlobalAsArray(new \StructType\GetShipmentTraceByDPDReferenceGlobalAsArray()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
