<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getShipmentTraceByReference StructType
 * @subpackage Structs
 */
class GetShipmentTraceByReference extends AbstractStructBase
{
    /**
     * The customer_center
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer_center;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The shipping_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipping_date;
    /**
     * Constructor method for getShipmentTraceByReference
     * @uses GetShipmentTraceByReference::setCustomer_center()
     * @uses GetShipmentTraceByReference::setCustomer()
     * @uses GetShipmentTraceByReference::setPassword()
     * @uses GetShipmentTraceByReference::setReference()
     * @uses GetShipmentTraceByReference::setShipping_date()
     * @param int $customer_center
     * @param int $customer
     * @param string $password
     * @param string $reference
     * @param string $shipping_date
     */
    public function __construct($customer_center = null, $customer = null, $password = null, $reference = null, $shipping_date = null)
    {
        $this
            ->setCustomer_center($customer_center)
            ->setCustomer($customer)
            ->setPassword($password)
            ->setReference($reference)
            ->setShipping_date($shipping_date);
    }
    /**
     * Get customer_center value
     * @return int
     */
    public function getCustomer_center()
    {
        return $this->customer_center;
    }
    /**
     * Set customer_center value
     * @param int $customer_center
     * @return \StructType\GetShipmentTraceByReference
     */
    public function setCustomer_center($customer_center = null)
    {
        // validation for constraint: int
        if (!is_null($customer_center) && !is_numeric($customer_center)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_center)), __LINE__);
        }
        $this->customer_center = $customer_center;
        return $this;
    }
    /**
     * Get customer value
     * @return int
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param int $customer
     * @return \StructType\GetShipmentTraceByReference
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: int
        if (!is_null($customer) && !is_numeric($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetShipmentTraceByReference
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\GetShipmentTraceByReference
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get shipping_date value
     * @return string|null
     */
    public function getShipping_date()
    {
        return $this->shipping_date;
    }
    /**
     * Set shipping_date value
     * @param string $shipping_date
     * @return \StructType\GetShipmentTraceByReference
     */
    public function setShipping_date($shipping_date = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_date) && !is_string($shipping_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_date)), __LINE__);
        }
        $this->shipping_date = $shipping_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShipmentTraceByReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
