<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getShipmentTraceByLanguageAsArray StructType
 * @subpackage Structs
 */
class GetShipmentTraceByLanguageAsArray extends AbstractStructBase
{
    /**
     * The customer_center
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer_center;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The shipmentnumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipmentnumber;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * Constructor method for getShipmentTraceByLanguageAsArray
     * @uses GetShipmentTraceByLanguageAsArray::setCustomer_center()
     * @uses GetShipmentTraceByLanguageAsArray::setCustomer()
     * @uses GetShipmentTraceByLanguageAsArray::setPassword()
     * @uses GetShipmentTraceByLanguageAsArray::setShipmentnumber()
     * @uses GetShipmentTraceByLanguageAsArray::setLanguage()
     * @param int $customer_center
     * @param int $customer
     * @param string $password
     * @param string $shipmentnumber
     * @param string $language
     */
    public function __construct($customer_center = null, $customer = null, $password = null, $shipmentnumber = null, $language = null)
    {
        $this
            ->setCustomer_center($customer_center)
            ->setCustomer($customer)
            ->setPassword($password)
            ->setShipmentnumber($shipmentnumber)
            ->setLanguage($language);
    }
    /**
     * Get customer_center value
     * @return int
     */
    public function getCustomer_center()
    {
        return $this->customer_center;
    }
    /**
     * Set customer_center value
     * @param int $customer_center
     * @return \StructType\GetShipmentTraceByLanguageAsArray
     */
    public function setCustomer_center($customer_center = null)
    {
        // validation for constraint: int
        if (!is_null($customer_center) && !is_numeric($customer_center)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_center)), __LINE__);
        }
        $this->customer_center = $customer_center;
        return $this;
    }
    /**
     * Get customer value
     * @return int
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param int $customer
     * @return \StructType\GetShipmentTraceByLanguageAsArray
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: int
        if (!is_null($customer) && !is_numeric($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetShipmentTraceByLanguageAsArray
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get shipmentnumber value
     * @return string|null
     */
    public function getShipmentnumber()
    {
        return $this->shipmentnumber;
    }
    /**
     * Set shipmentnumber value
     * @param string $shipmentnumber
     * @return \StructType\GetShipmentTraceByLanguageAsArray
     */
    public function setShipmentnumber($shipmentnumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentnumber) && !is_string($shipmentnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentnumber)), __LINE__);
        }
        $this->shipmentnumber = $shipmentnumber;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetShipmentTraceByLanguageAsArray
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShipmentTraceByLanguageAsArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
