<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsTrace StructType
 * @subpackage Structs
 */
class ClsTrace extends AbstractStructBase
{
    /**
     * The StatusNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusNumber;
    /**
     * The ScanDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanDate;
    /**
     * The ScanTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanTime;
    /**
     * The StatusDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDescription;
    /**
     * The CenterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CenterName;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $User;
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remark;
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClsTraceDetails
     */
    public $Details;
    /**
     * Constructor method for clsTrace
     * @uses ClsTrace::setStatusNumber()
     * @uses ClsTrace::setScanDate()
     * @uses ClsTrace::setScanTime()
     * @uses ClsTrace::setStatusDescription()
     * @uses ClsTrace::setCenterName()
     * @uses ClsTrace::setUser()
     * @uses ClsTrace::setRemark()
     * @uses ClsTrace::setInfo()
     * @uses ClsTrace::setDetails()
     * @param int $statusNumber
     * @param string $scanDate
     * @param string $scanTime
     * @param string $statusDescription
     * @param string $centerName
     * @param string $user
     * @param string $remark
     * @param string $info
     * @param \ArrayType\ArrayOfClsTraceDetails $details
     */
    public function __construct($statusNumber = null, $scanDate = null, $scanTime = null, $statusDescription = null, $centerName = null, $user = null, $remark = null, $info = null, \ArrayType\ArrayOfClsTraceDetails $details = null)
    {
        $this
            ->setStatusNumber($statusNumber)
            ->setScanDate($scanDate)
            ->setScanTime($scanTime)
            ->setStatusDescription($statusDescription)
            ->setCenterName($centerName)
            ->setUser($user)
            ->setRemark($remark)
            ->setInfo($info)
            ->setDetails($details);
    }
    /**
     * Get StatusNumber value
     * @return int
     */
    public function getStatusNumber()
    {
        return $this->StatusNumber;
    }
    /**
     * Set StatusNumber value
     * @param int $statusNumber
     * @return \StructType\ClsTrace
     */
    public function setStatusNumber($statusNumber = null)
    {
        // validation for constraint: int
        if (!is_null($statusNumber) && !is_numeric($statusNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusNumber)), __LINE__);
        }
        $this->StatusNumber = $statusNumber;
        return $this;
    }
    /**
     * Get ScanDate value
     * @return string|null
     */
    public function getScanDate()
    {
        return $this->ScanDate;
    }
    /**
     * Set ScanDate value
     * @param string $scanDate
     * @return \StructType\ClsTrace
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scanDate)), __LINE__);
        }
        $this->ScanDate = $scanDate;
        return $this;
    }
    /**
     * Get ScanTime value
     * @return string|null
     */
    public function getScanTime()
    {
        return $this->ScanTime;
    }
    /**
     * Set ScanTime value
     * @param string $scanTime
     * @return \StructType\ClsTrace
     */
    public function setScanTime($scanTime = null)
    {
        // validation for constraint: string
        if (!is_null($scanTime) && !is_string($scanTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scanTime)), __LINE__);
        }
        $this->ScanTime = $scanTime;
        return $this;
    }
    /**
     * Get StatusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->StatusDescription;
    }
    /**
     * Set StatusDescription value
     * @param string $statusDescription
     * @return \StructType\ClsTrace
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDescription)), __LINE__);
        }
        $this->StatusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get CenterName value
     * @return string|null
     */
    public function getCenterName()
    {
        return $this->CenterName;
    }
    /**
     * Set CenterName value
     * @param string $centerName
     * @return \StructType\ClsTrace
     */
    public function setCenterName($centerName = null)
    {
        // validation for constraint: string
        if (!is_null($centerName) && !is_string($centerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($centerName)), __LINE__);
        }
        $this->CenterName = $centerName;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\ClsTrace
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\ClsTrace
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\ClsTrace
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfClsTraceDetails|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfClsTraceDetails $details
     * @return \StructType\ClsTrace
     */
    public function setDetails(\ArrayType\ArrayOfClsTraceDetails $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsTrace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
