<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsShipmentTraceBase StructType
 * @subpackage Structs
 */
class ClsShipmentTraceBase extends AbstractStructBase
{
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Weight;
    /**
     * The IsB2C
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsB2C;
    /**
     * The IsRetour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRetour;
    /**
     * The CustomerCenternumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerCenternumber;
    /**
     * The CustomerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerNumber;
    /**
     * The LastError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastError;
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The DestinationCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCountry;
    /**
     * The DestinationZipcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationZipcode;
    /**
     * The ShippingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingDate;
    /**
     * The DeliveryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Receiver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receiver;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The DeliveryScheduled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SdgiData
     */
    public $DeliveryScheduled;
    /**
     * The Traces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClsTrace
     */
    public $Traces;
    /**
     * The Reference_International
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference_International;
    /**
     * The PointRelaisName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PointRelaisName;
    /**
     * The PointRelaisLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PointRelaisLink;
    /**
     * The ShipmentNumber_Retour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentNumber_Retour;
    /**
     * Constructor method for clsShipmentTraceBase
     * @uses ClsShipmentTraceBase::setWeight()
     * @uses ClsShipmentTraceBase::setIsB2C()
     * @uses ClsShipmentTraceBase::setIsRetour()
     * @uses ClsShipmentTraceBase::setCustomerCenternumber()
     * @uses ClsShipmentTraceBase::setCustomerNumber()
     * @uses ClsShipmentTraceBase::setLastError()
     * @uses ClsShipmentTraceBase::setShipmentNumber()
     * @uses ClsShipmentTraceBase::setDestinationCountry()
     * @uses ClsShipmentTraceBase::setDestinationZipcode()
     * @uses ClsShipmentTraceBase::setShippingDate()
     * @uses ClsShipmentTraceBase::setDeliveryDate()
     * @uses ClsShipmentTraceBase::setReceiver()
     * @uses ClsShipmentTraceBase::setReference()
     * @uses ClsShipmentTraceBase::setDeliveryScheduled()
     * @uses ClsShipmentTraceBase::setTraces()
     * @uses ClsShipmentTraceBase::setReference_International()
     * @uses ClsShipmentTraceBase::setPointRelaisName()
     * @uses ClsShipmentTraceBase::setPointRelaisLink()
     * @uses ClsShipmentTraceBase::setShipmentNumber_Retour()
     * @param float $weight
     * @param bool $isB2C
     * @param bool $isRetour
     * @param int $customerCenternumber
     * @param int $customerNumber
     * @param string $lastError
     * @param string $shipmentNumber
     * @param string $destinationCountry
     * @param string $destinationZipcode
     * @param string $shippingDate
     * @param string $deliveryDate
     * @param string $receiver
     * @param string $reference
     * @param \StructType\SdgiData $deliveryScheduled
     * @param \ArrayType\ArrayOfClsTrace $traces
     * @param string $reference_International
     * @param string $pointRelaisName
     * @param string $pointRelaisLink
     * @param string $shipmentNumber_Retour
     */
    public function __construct($weight = null, $isB2C = null, $isRetour = null, $customerCenternumber = null, $customerNumber = null, $lastError = null, $shipmentNumber = null, $destinationCountry = null, $destinationZipcode = null, $shippingDate = null, $deliveryDate = null, $receiver = null, $reference = null, \StructType\SdgiData $deliveryScheduled = null, \ArrayType\ArrayOfClsTrace $traces = null, $reference_International = null, $pointRelaisName = null, $pointRelaisLink = null, $shipmentNumber_Retour = null)
    {
        $this
            ->setWeight($weight)
            ->setIsB2C($isB2C)
            ->setIsRetour($isRetour)
            ->setCustomerCenternumber($customerCenternumber)
            ->setCustomerNumber($customerNumber)
            ->setLastError($lastError)
            ->setShipmentNumber($shipmentNumber)
            ->setDestinationCountry($destinationCountry)
            ->setDestinationZipcode($destinationZipcode)
            ->setShippingDate($shippingDate)
            ->setDeliveryDate($deliveryDate)
            ->setReceiver($receiver)
            ->setReference($reference)
            ->setDeliveryScheduled($deliveryScheduled)
            ->setTraces($traces)
            ->setReference_International($reference_International)
            ->setPointRelaisName($pointRelaisName)
            ->setPointRelaisLink($pointRelaisLink)
            ->setShipmentNumber_Retour($shipmentNumber_Retour);
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get IsB2C value
     * @return bool
     */
    public function getIsB2C()
    {
        return $this->IsB2C;
    }
    /**
     * Set IsB2C value
     * @param bool $isB2C
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setIsB2C($isB2C = null)
    {
        // validation for constraint: boolean
        if (!is_null($isB2C) && !is_bool($isB2C)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isB2C)), __LINE__);
        }
        $this->IsB2C = $isB2C;
        return $this;
    }
    /**
     * Get IsRetour value
     * @return bool
     */
    public function getIsRetour()
    {
        return $this->IsRetour;
    }
    /**
     * Set IsRetour value
     * @param bool $isRetour
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setIsRetour($isRetour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRetour) && !is_bool($isRetour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRetour)), __LINE__);
        }
        $this->IsRetour = $isRetour;
        return $this;
    }
    /**
     * Get CustomerCenternumber value
     * @return int
     */
    public function getCustomerCenternumber()
    {
        return $this->CustomerCenternumber;
    }
    /**
     * Set CustomerCenternumber value
     * @param int $customerCenternumber
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setCustomerCenternumber($customerCenternumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerCenternumber) && !is_numeric($customerCenternumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerCenternumber)), __LINE__);
        }
        $this->CustomerCenternumber = $customerCenternumber;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return int
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !is_numeric($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get LastError value
     * @return string|null
     */
    public function getLastError()
    {
        return $this->LastError;
    }
    /**
     * Set LastError value
     * @param string $lastError
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setLastError($lastError = null)
    {
        // validation for constraint: string
        if (!is_null($lastError) && !is_string($lastError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastError)), __LINE__);
        }
        $this->LastError = $lastError;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get DestinationCountry value
     * @return string|null
     */
    public function getDestinationCountry()
    {
        return $this->DestinationCountry;
    }
    /**
     * Set DestinationCountry value
     * @param string $destinationCountry
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setDestinationCountry($destinationCountry = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCountry) && !is_string($destinationCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationCountry)), __LINE__);
        }
        $this->DestinationCountry = $destinationCountry;
        return $this;
    }
    /**
     * Get DestinationZipcode value
     * @return string|null
     */
    public function getDestinationZipcode()
    {
        return $this->DestinationZipcode;
    }
    /**
     * Set DestinationZipcode value
     * @param string $destinationZipcode
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setDestinationZipcode($destinationZipcode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZipcode) && !is_string($destinationZipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationZipcode)), __LINE__);
        }
        $this->DestinationZipcode = $destinationZipcode;
        return $this;
    }
    /**
     * Get ShippingDate value
     * @return string|null
     */
    public function getShippingDate()
    {
        return $this->ShippingDate;
    }
    /**
     * Set ShippingDate value
     * @param string $shippingDate
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingDate)), __LINE__);
        }
        $this->ShippingDate = $shippingDate;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get Receiver value
     * @return string|null
     */
    public function getReceiver()
    {
        return $this->Receiver;
    }
    /**
     * Set Receiver value
     * @param string $receiver
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setReceiver($receiver = null)
    {
        // validation for constraint: string
        if (!is_null($receiver) && !is_string($receiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiver)), __LINE__);
        }
        $this->Receiver = $receiver;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get DeliveryScheduled value
     * @return \StructType\SdgiData|null
     */
    public function getDeliveryScheduled()
    {
        return $this->DeliveryScheduled;
    }
    /**
     * Set DeliveryScheduled value
     * @param \StructType\SdgiData $deliveryScheduled
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setDeliveryScheduled(\StructType\SdgiData $deliveryScheduled = null)
    {
        $this->DeliveryScheduled = $deliveryScheduled;
        return $this;
    }
    /**
     * Get Traces value
     * @return \ArrayType\ArrayOfClsTrace|null
     */
    public function getTraces()
    {
        return $this->Traces;
    }
    /**
     * Set Traces value
     * @param \ArrayType\ArrayOfClsTrace $traces
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setTraces(\ArrayType\ArrayOfClsTrace $traces = null)
    {
        $this->Traces = $traces;
        return $this;
    }
    /**
     * Get Reference_International value
     * @return string|null
     */
    public function getReference_International()
    {
        return $this->Reference_International;
    }
    /**
     * Set Reference_International value
     * @param string $reference_International
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setReference_International($reference_International = null)
    {
        // validation for constraint: string
        if (!is_null($reference_International) && !is_string($reference_International)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference_International)), __LINE__);
        }
        $this->Reference_International = $reference_International;
        return $this;
    }
    /**
     * Get PointRelaisName value
     * @return string|null
     */
    public function getPointRelaisName()
    {
        return $this->PointRelaisName;
    }
    /**
     * Set PointRelaisName value
     * @param string $pointRelaisName
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setPointRelaisName($pointRelaisName = null)
    {
        // validation for constraint: string
        if (!is_null($pointRelaisName) && !is_string($pointRelaisName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pointRelaisName)), __LINE__);
        }
        $this->PointRelaisName = $pointRelaisName;
        return $this;
    }
    /**
     * Get PointRelaisLink value
     * @return string|null
     */
    public function getPointRelaisLink()
    {
        return $this->PointRelaisLink;
    }
    /**
     * Set PointRelaisLink value
     * @param string $pointRelaisLink
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setPointRelaisLink($pointRelaisLink = null)
    {
        // validation for constraint: string
        if (!is_null($pointRelaisLink) && !is_string($pointRelaisLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pointRelaisLink)), __LINE__);
        }
        $this->PointRelaisLink = $pointRelaisLink;
        return $this;
    }
    /**
     * Get ShipmentNumber_Retour value
     * @return string|null
     */
    public function getShipmentNumber_Retour()
    {
        return $this->ShipmentNumber_Retour;
    }
    /**
     * Set ShipmentNumber_Retour value
     * @param string $shipmentNumber_Retour
     * @return \StructType\ClsShipmentTraceBase
     */
    public function setShipmentNumber_Retour($shipmentNumber_Retour = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber_Retour) && !is_string($shipmentNumber_Retour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentNumber_Retour)), __LINE__);
        }
        $this->ShipmentNumber_Retour = $shipmentNumber_Retour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsShipmentTraceBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
