<?php

namespace EnumType;

/**
 * This class stands for ReferenceSearchMode EnumType
 * @subpackage Enumerations
 */
class ReferenceSearchMode
{
    /**
     * Constant for value 'SearchMode_Equals'
     * @return string 'SearchMode_Equals'
     */
    const VALUE_SEARCH_MODE_EQUALS = 'SearchMode_Equals';
    /**
     * Constant for value 'SearchMode_Like'
     * @return string 'SearchMode_Like'
     */
    const VALUE_SEARCH_MODE_LIKE = 'SearchMode_Like';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SEARCH_MODE_EQUALS
     * @uses self::VALUE_SEARCH_MODE_LIKE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEARCH_MODE_EQUALS,
            self::VALUE_SEARCH_MODE_LIKE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
