<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getShipmentTraceByReferenceAndLanguageAsArray StructType
 * @subpackage Structs
 */
class GetShipmentTraceByReferenceAndLanguageAsArray extends AbstractStructBase
{
    /**
     * The customer_center
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer_center;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer;
    /**
     * The searchmode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $searchmode;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The shipping_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipping_date;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * Constructor method for getShipmentTraceByReferenceAndLanguageAsArray
     * @uses GetShipmentTraceByReferenceAndLanguageAsArray::setCustomer_center()
     * @uses GetShipmentTraceByReferenceAndLanguageAsArray::setCustomer()
     * @uses GetShipmentTraceByReferenceAndLanguageAsArray::setSearchmode()
     * @uses GetShipmentTraceByReferenceAndLanguageAsArray::setPassword()
     * @uses GetShipmentTraceByReferenceAndLanguageAsArray::setReference()
     * @uses GetShipmentTraceByReferenceAndLanguageAsArray::setShipping_date()
     * @uses GetShipmentTraceByReferenceAndLanguageAsArray::setLanguage()
     * @param int $customer_center
     * @param int $customer
     * @param string $searchmode
     * @param string $password
     * @param string $reference
     * @param string $shipping_date
     * @param string $language
     */
    public function __construct($customer_center = null, $customer = null, $searchmode = null, $password = null, $reference = null, $shipping_date = null, $language = null)
    {
        $this
            ->setCustomer_center($customer_center)
            ->setCustomer($customer)
            ->setSearchmode($searchmode)
            ->setPassword($password)
            ->setReference($reference)
            ->setShipping_date($shipping_date)
            ->setLanguage($language);
    }
    /**
     * Get customer_center value
     * @return int
     */
    public function getCustomer_center()
    {
        return $this->customer_center;
    }
    /**
     * Set customer_center value
     * @param int $customer_center
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public function setCustomer_center($customer_center = null)
    {
        // validation for constraint: int
        if (!is_null($customer_center) && !is_numeric($customer_center)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_center)), __LINE__);
        }
        $this->customer_center = $customer_center;
        return $this;
    }
    /**
     * Get customer value
     * @return int
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param int $customer
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: int
        if (!is_null($customer) && !is_numeric($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get searchmode value
     * @return string
     */
    public function getSearchmode()
    {
        return $this->searchmode;
    }
    /**
     * Set searchmode value
     * @uses \EnumType\ReferenceSearchMode::valueIsValid()
     * @uses \EnumType\ReferenceSearchMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchmode
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public function setSearchmode($searchmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReferenceSearchMode::valueIsValid($searchmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchmode, implode(', ', \EnumType\ReferenceSearchMode::getValidValues())), __LINE__);
        }
        $this->searchmode = $searchmode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get shipping_date value
     * @return string|null
     */
    public function getShipping_date()
    {
        return $this->shipping_date;
    }
    /**
     * Set shipping_date value
     * @param string $shipping_date
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public function setShipping_date($shipping_date = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_date) && !is_string($shipping_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_date)), __LINE__);
        }
        $this->shipping_date = $shipping_date;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShipmentTraceByReferenceAndLanguageAsArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
