<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getShipmentTraceByDPDReferenceGlobalAsArray StructType
 * @subpackage Structs
 */
class GetShipmentTraceByDPDReferenceGlobalAsArray extends AbstractStructBase
{
    /**
     * The customer_center
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer_center;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customer;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The dpd_reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dpd_reference;
    /**
     * Constructor method for getShipmentTraceByDPDReferenceGlobalAsArray
     * @uses GetShipmentTraceByDPDReferenceGlobalAsArray::setCustomer_center()
     * @uses GetShipmentTraceByDPDReferenceGlobalAsArray::setCustomer()
     * @uses GetShipmentTraceByDPDReferenceGlobalAsArray::setPassword()
     * @uses GetShipmentTraceByDPDReferenceGlobalAsArray::setDpd_reference()
     * @param int $customer_center
     * @param int $customer
     * @param string $password
     * @param string $dpd_reference
     */
    public function __construct($customer_center = null, $customer = null, $password = null, $dpd_reference = null)
    {
        $this
            ->setCustomer_center($customer_center)
            ->setCustomer($customer)
            ->setPassword($password)
            ->setDpd_reference($dpd_reference);
    }
    /**
     * Get customer_center value
     * @return int
     */
    public function getCustomer_center()
    {
        return $this->customer_center;
    }
    /**
     * Set customer_center value
     * @param int $customer_center
     * @return \StructType\GetShipmentTraceByDPDReferenceGlobalAsArray
     */
    public function setCustomer_center($customer_center = null)
    {
        // validation for constraint: int
        if (!is_null($customer_center) && !is_numeric($customer_center)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_center)), __LINE__);
        }
        $this->customer_center = $customer_center;
        return $this;
    }
    /**
     * Get customer value
     * @return int
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param int $customer
     * @return \StructType\GetShipmentTraceByDPDReferenceGlobalAsArray
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: int
        if (!is_null($customer) && !is_numeric($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetShipmentTraceByDPDReferenceGlobalAsArray
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get dpd_reference value
     * @return string|null
     */
    public function getDpd_reference()
    {
        return $this->dpd_reference;
    }
    /**
     * Set dpd_reference value
     * @param string $dpd_reference
     * @return \StructType\GetShipmentTraceByDPDReferenceGlobalAsArray
     */
    public function setDpd_reference($dpd_reference = null)
    {
        // validation for constraint: string
        if (!is_null($dpd_reference) && !is_string($dpd_reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dpd_reference)), __LINE__);
        }
        $this->dpd_reference = $dpd_reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShipmentTraceByDPDReferenceGlobalAsArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
