<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getShipmentTrace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTrace $parameters
     * @return \StructType\GetShipmentTraceResponse|bool
     */
    public function getShipmentTrace(\StructType\GetShipmentTrace $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTrace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipmentTraceAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceAsArray $parameters
     * @return \ArrayType\GetShipmentTraceAsArrayResponse|bool
     */
    public function getShipmentTraceAsArray(\StructType\GetShipmentTraceAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipmentTraceByLanguageAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByLanguageAsArray $parameters
     * @return \ArrayType\GetShipmentTraceByLanguageAsArrayResponse|bool
     */
    public function getShipmentTraceByLanguageAsArray(\StructType\GetShipmentTraceByLanguageAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByLanguageAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipmentTraceWithImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceWithImages $parameters
     * @return \StructType\GetShipmentTraceWithImagesResponse|bool
     */
    public function getShipmentTraceWithImages(\StructType\GetShipmentTraceWithImages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceWithImages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipmentTraceByReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReference $parameters
     * @return \StructType\GetShipmentTraceByReferenceResponse|bool
     */
    public function getShipmentTraceByReference(\StructType\GetShipmentTraceByReference $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipmentTraceByReferenceAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceAsArray $parameters
     * @return \ArrayType\GetShipmentTraceByReferenceAsArrayResponse|bool
     */
    public function getShipmentTraceByReferenceAsArray(\StructType\GetShipmentTraceByReferenceAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getShipmentTraceByReferenceAndLanguageAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceAndLanguageAsArray $parameters
     * @return \ArrayType\GetShipmentTraceByReferenceAndLanguageAsArrayResponse|bool
     */
    public function getShipmentTraceByReferenceAndLanguageAsArray(\StructType\GetShipmentTraceByReferenceAndLanguageAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceAndLanguageAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getShipmentTraceByReferenceWithImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceWithImages $parameters
     * @return \StructType\GetShipmentTraceByReferenceWithImagesResponse|bool
     */
    public function getShipmentTraceByReferenceWithImages(\StructType\GetShipmentTraceByReferenceWithImages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceWithImages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipmentTraceByReferenceGlobal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceGlobal $parameters
     * @return \StructType\GetShipmentTraceByReferenceGlobalResponse|bool
     */
    public function getShipmentTraceByReferenceGlobal(\StructType\GetShipmentTraceByReferenceGlobal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceGlobal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getShipmentTraceByReferenceGlobalAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceGlobalAsArray $parameters
     * @return \ArrayType\GetShipmentTraceByReferenceGlobalAsArrayResponse|bool
     */
    public function getShipmentTraceByReferenceGlobalAsArray(\StructType\GetShipmentTraceByReferenceGlobalAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceGlobalAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getShipmentTraceByReferenceGlobalWithCenterAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceGlobalWithCenterAsArray $parameters
     * @return \ArrayType\GetShipmentTraceByReferenceGlobalWithCenterAsArrayResponse|bool
     */
    public function getShipmentTraceByReferenceGlobalWithCenterAsArray(\StructType\GetShipmentTraceByReferenceGlobalWithCenterAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceGlobalWithCenterAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getShipmentTraceByReferenceAndLanguageGlobalAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceAndLanguageGlobalAsArray $parameters
     * @return \ArrayType\GetShipmentTraceByReferenceAndLanguageGlobalAsArrayResponse|bool
     */
    public function getShipmentTraceByReferenceAndLanguageGlobalAsArray(\StructType\GetShipmentTraceByReferenceAndLanguageGlobalAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceAndLanguageGlobalAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getShipmentTraceByReferenceGlobalWithImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByReferenceGlobalWithImages $parameters
     * @return \StructType\GetShipmentTraceByReferenceGlobalWithImagesResponse|bool
     */
    public function getShipmentTraceByReferenceGlobalWithImages(\StructType\GetShipmentTraceByReferenceGlobalWithImages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByReferenceGlobalWithImages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getShipmentTraceByDPDReferenceGlobalAsArray
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentTraceByDPDReferenceGlobalAsArray $parameters
     * @return \ArrayType\GetShipmentTraceByDPDReferenceGlobalAsArrayResponse|bool
     */
    public function getShipmentTraceByDPDReferenceGlobalAsArray(\StructType\GetShipmentTraceByDPDReferenceGlobalAsArray $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getShipmentTraceByDPDReferenceGlobalAsArray($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ArrayType\GetShipmentTraceAsArrayResponse|\ArrayType\GetShipmentTraceByDPDReferenceGlobalAsArrayResponse|\ArrayType\GetShipmentTraceByLanguageAsArrayResponse|\ArrayType\GetShipmentTraceByReferenceAndLanguageAsArrayResponse|\ArrayType\GetShipmentTraceByReferenceAndLanguageGlobalAsArrayResponse|\ArrayType\GetShipmentTraceByReferenceAsArrayResponse|\ArrayType\GetShipmentTraceByReferenceGlobalAsArrayResponse|\ArrayType\GetShipmentTraceByReferenceGlobalWithCenterAsArrayResponse|\StructType\GetShipmentTraceByReferenceGlobalResponse|\StructType\GetShipmentTraceByReferenceGlobalWithImagesResponse|\StructType\GetShipmentTraceByReferenceResponse|\StructType\GetShipmentTraceByReferenceWithImagesResponse|\StructType\GetShipmentTraceResponse|\StructType\GetShipmentTraceWithImagesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
