<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClsTraceDetails ArrayType
 * @subpackage Arrays
 */
class ArrayOfClsTraceDetails extends AbstractStructArrayBase
{
    /**
     * The clsTraceDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsTraceDetails[]
     */
    public $clsTraceDetails;
    /**
     * Constructor method for ArrayOfClsTraceDetails
     * @uses ArrayOfClsTraceDetails::setClsTraceDetails()
     * @param \StructType\ClsTraceDetails[] $clsTraceDetails
     */
    public function __construct(array $clsTraceDetails = array())
    {
        $this
            ->setClsTraceDetails($clsTraceDetails);
    }
    /**
     * Get clsTraceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsTraceDetails[]|null
     */
    public function getClsTraceDetails()
    {
        return isset($this->clsTraceDetails) ? $this->clsTraceDetails : null;
    }
    /**
     * Set clsTraceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClsTraceDetails[] $clsTraceDetails
     * @return \ArrayType\ArrayOfClsTraceDetails
     */
    public function setClsTraceDetails(array $clsTraceDetails = array())
    {
        foreach ($clsTraceDetails as $arrayOfClsTraceDetailsClsTraceDetailsItem) {
            // validation for constraint: itemType
            if (!$arrayOfClsTraceDetailsClsTraceDetailsItem instanceof \StructType\ClsTraceDetails) {
                throw new \InvalidArgumentException(sprintf('The clsTraceDetails property can only contain items of \StructType\ClsTraceDetails, "%s" given', is_object($arrayOfClsTraceDetailsClsTraceDetailsItem) ? get_class($arrayOfClsTraceDetailsClsTraceDetailsItem) : gettype($arrayOfClsTraceDetailsClsTraceDetailsItem)), __LINE__);
            }
        }
        if (is_null($clsTraceDetails) || (is_array($clsTraceDetails) && empty($clsTraceDetails))) {
            unset($this->clsTraceDetails);
        } else {
            $this->clsTraceDetails = $clsTraceDetails;
        }
        return $this;
    }
    /**
     * Add item to clsTraceDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ClsTraceDetails $item
     * @return \ArrayType\ArrayOfClsTraceDetails
     */
    public function addToClsTraceDetails(\StructType\ClsTraceDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClsTraceDetails) {
            throw new \InvalidArgumentException(sprintf('The clsTraceDetails property can only contain items of \StructType\ClsTraceDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->clsTraceDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClsTraceDetails|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClsTraceDetails|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClsTraceDetails|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClsTraceDetails|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClsTraceDetails|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string clsTraceDetails
     */
    public function getAttributeName()
    {
        return 'clsTraceDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClsTraceDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
