<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClsTrace ArrayType
 * @subpackage Arrays
 */
class ArrayOfClsTrace extends AbstractStructArrayBase
{
    /**
     * The clsTrace
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsTrace[]
     */
    public $clsTrace;
    /**
     * Constructor method for ArrayOfClsTrace
     * @uses ArrayOfClsTrace::setClsTrace()
     * @param \StructType\ClsTrace[] $clsTrace
     */
    public function __construct(array $clsTrace = array())
    {
        $this
            ->setClsTrace($clsTrace);
    }
    /**
     * Get clsTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsTrace[]|null
     */
    public function getClsTrace()
    {
        return isset($this->clsTrace) ? $this->clsTrace : null;
    }
    /**
     * Set clsTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClsTrace[] $clsTrace
     * @return \ArrayType\ArrayOfClsTrace
     */
    public function setClsTrace(array $clsTrace = array())
    {
        foreach ($clsTrace as $arrayOfClsTraceClsTraceItem) {
            // validation for constraint: itemType
            if (!$arrayOfClsTraceClsTraceItem instanceof \StructType\ClsTrace) {
                throw new \InvalidArgumentException(sprintf('The clsTrace property can only contain items of \StructType\ClsTrace, "%s" given', is_object($arrayOfClsTraceClsTraceItem) ? get_class($arrayOfClsTraceClsTraceItem) : gettype($arrayOfClsTraceClsTraceItem)), __LINE__);
            }
        }
        if (is_null($clsTrace) || (is_array($clsTrace) && empty($clsTrace))) {
            unset($this->clsTrace);
        } else {
            $this->clsTrace = $clsTrace;
        }
        return $this;
    }
    /**
     * Add item to clsTrace value
     * @throws \InvalidArgumentException
     * @param \StructType\ClsTrace $item
     * @return \ArrayType\ArrayOfClsTrace
     */
    public function addToClsTrace(\StructType\ClsTrace $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClsTrace) {
            throw new \InvalidArgumentException(sprintf('The clsTrace property can only contain items of \StructType\ClsTrace, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->clsTrace[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClsTrace|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClsTrace|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClsTrace|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClsTrace|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClsTrace|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string clsTrace
     */
    public function getAttributeName()
    {
        return 'clsTrace';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClsTrace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
