<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://staging-ws.epower.amadeus.com/wsunspree/EpowerService.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://staging-ws.epower.amadeus.com/wsunspree/EpowerService.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \dgsoft\DgClassMap::get(),
);
/**
 * Samples for Ping ServiceType
 */
$ping = new \dgsoft\ServiceType\DgPing($options);
$ping->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$ping->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \dgsoft\StructType\DgPing()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Sign ServiceType
 */
$sign = new \dgsoft\ServiceType\DgSign($options);
/**
 * Sample call for SignOut operation/method
 */
if ($sign->SignOut(new \dgsoft\StructType\DgSignOut()) !== false) {
    print_r($sign->getResult());
} else {
    print_r($sign->getLastError());
}
/**
 * Samples for Currency ServiceType
 */
$currency = new \dgsoft\ServiceType\DgCurrency($options);
$currency->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$currency->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for CurrencyConversion operation/method
 */
if ($currency->CurrencyConversion(new \dgsoft\StructType\DgCurrencyConversion()) !== false) {
    print_r($currency->getResult());
} else {
    print_r($currency->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \dgsoft\ServiceType\DgCancel($options);
$cancel->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$cancel->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for Cancel operation/method
 */
if ($cancel->Cancel(new \dgsoft\StructType\DgCancel()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Queue ServiceType
 */
$queue = new \dgsoft\ServiceType\DgQueue($options);
$queue->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$queue->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for Queue operation/method
 */
if ($queue->Queue(new \dgsoft\StructType\DgQueue()) !== false) {
    print_r($queue->getResult());
} else {
    print_r($queue->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \dgsoft\ServiceType\DgAdd($options);
$add->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$add->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for AddPNRToQueue operation/method
 */
if ($add->AddPNRToQueue(new \dgsoft\StructType\DgAddPNRToQueue()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \dgsoft\ServiceType\DgSearch($options);
$search->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$search->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for SearchFlight operation/method
 */
if ($search->SearchFlight(new \dgsoft\StructType\DgSearchFlight()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchFlightCalendar operation/method
 */
if ($search->SearchFlightCalendar(new \dgsoft\StructType\DgSearchFlightCalendar()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchFlightTimeTable operation/method
 */
if ($search->SearchFlightTimeTable(new \dgsoft\StructType\DgSearchFlightTimeTable()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchHotel operation/method
 */
if ($search->SearchHotel(new \dgsoft\StructType\DgSearchHotel()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchHotelRooms operation/method
 */
if ($search->SearchHotelRooms(new \dgsoft\StructType\DgSearchHotelRooms()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchCar operation/method
 */
if ($search->SearchCar(new \dgsoft\StructType\DgSearchCar()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchCarVendor operation/method
 */
if ($search->SearchCarVendor(new \dgsoft\StructType\DgSearchCarVendor()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchInsurancePlans operation/method
 */
if ($search->SearchInsurancePlans(new \dgsoft\StructType\DgSearchInsurancePlans()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \dgsoft\ServiceType\DgGet($options);
$get->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$get->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for GetServiceFee operation/method
 */
if ($get->GetServiceFee(new \dgsoft\StructType\DgGetServiceFee()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBaggageInfo operation/method
 */
if ($get->GetBaggageInfo(new \dgsoft\StructType\DgGetBaggageInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAncillaryInfo operation/method
 */
if ($get->GetAncillaryInfo(new \dgsoft\StructType\DgGetAncillaryInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompatibleLowestFaresForSunExpress operation/method
 */
if ($get->GetCompatibleLowestFaresForSunExpress(new \dgsoft\StructType\DgGetCompatibleLowestFaresForSunExpress()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServiceFeeV2 operation/method
 */
if ($get->GetServiceFeeV2(new \dgsoft\StructType\DgGetServiceFeeV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPrice operation/method
 */
if ($get->GetPrice(new \dgsoft\StructType\DgGetPrice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRequiredParametersForLCC operation/method
 */
if ($get->GetRequiredParametersForLCC(new \dgsoft\StructType\DgGetRequiredParametersForLCC()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNextFlightResults operation/method
 */
if ($get->GetNextFlightResults(new \dgsoft\StructType\DgGetNextFlightResults()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFlightRules operation/method
 */
if ($get->GetFlightRules(new \dgsoft\StructType\DgGetFlightRules()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPNR operation/method
 */
if ($get->GetPNR(new \dgsoft\StructType\DgGetPNR()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPNRPrice operation/method
 */
if ($get->GetPNRPrice(new \dgsoft\StructType\DgGetPNRPrice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastTicketingDate operation/method
 */
if ($get->GetLastTicketingDate(new \dgsoft\StructType\DgGetLastTicketingDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSeatMap operation/method
 */
if ($get->GetSeatMap(new \dgsoft\StructType\DgGetSeatMap()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCancelPolicyText operation/method
 */
if ($get->GetCancelPolicyText(new \dgsoft\StructType\DgGetCancelPolicyText()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHotelInfo operation/method
 */
if ($get->GetHotelInfo(new \dgsoft\StructType\DgGetHotelInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHotelRoomRules operation/method
 */
if ($get->GetHotelRoomRules(new \dgsoft\StructType\DgGetHotelRoomRules()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHotelPNR operation/method
 */
if ($get->GetHotelPNR(new \dgsoft\StructType\DgGetHotelPNR()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCarCompanyLocations operation/method
 */
if ($get->GetCarCompanyLocations(new \dgsoft\StructType\DgGetCarCompanyLocations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCarRules operation/method
 */
if ($get->GetCarRules(new \dgsoft\StructType\DgGetCarRules()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCarPNR operation/method
 */
if ($get->GetCarPNR(new \dgsoft\StructType\DgGetCarPNR()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBasketPNR operation/method
 */
if ($get->GetBasketPNR(new \dgsoft\StructType\DgGetBasketPNR()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUser operation/method
 */
if ($get->GetUser(new \dgsoft\StructType\DgGetUser()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAPISRules operation/method
 */
if ($get->GetAPISRules(new \dgsoft\StructType\DgGetAPISRules()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFlightFareFamilies operation/method
 */
if ($get->GetFlightFareFamilies(new \dgsoft\StructType\DgGetFlightFareFamilies()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \dgsoft\ServiceType\DgCheck($options);
$check->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$check->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for CheckETicket operation/method
 */
if ($check->CheckETicket(new \dgsoft\StructType\DgCheckETicket()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \dgsoft\ServiceType\DgBook($options);
$book->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$book->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for BookFlight operation/method
 */
if ($book->BookFlight(new \dgsoft\StructType\DgBookFlight()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Sample call for BookFlightWithRecommendation operation/method
 */
if ($book->BookFlightWithRecommendation(new \dgsoft\StructType\DgBookFlightWithRecommendation()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Sample call for BookHotel operation/method
 */
if ($book->BookHotel(new \dgsoft\StructType\DgBookHotel()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Sample call for BookCar operation/method
 */
if ($book->BookCar(new \dgsoft\StructType\DgBookCar()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Sample call for BookInsurance operation/method
 */
if ($book->BookInsurance(new \dgsoft\StructType\DgBookInsurance()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Sample call for Book operation/method
 */
if ($book->Book(new \dgsoft\StructType\DgBook()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \dgsoft\ServiceType\DgCreate($options);
$create->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$create->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for CreateTicket operation/method
 */
if ($create->CreateTicket(new \dgsoft\StructType\DgCreateTicket()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Edit ServiceType
 */
$edit = new \dgsoft\ServiceType\DgEdit($options);
$edit->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$edit->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for EditPNR operation/method
 */
if ($edit->EditPNR(new \dgsoft\StructType\DgEditPNR()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \dgsoft\ServiceType\DgExecute($options);
$execute->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$execute->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for ExecuteCommand operation/method
 */
if ($execute->ExecuteCommand(new \dgsoft\StructType\DgExecuteCommand()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \dgsoft\ServiceType\DgRegister($options);
$register->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$register->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for RegisterUser operation/method
 */
if ($register->RegisterUser(new \dgsoft\StructType\DgRegisterUser()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \dgsoft\ServiceType\DgUpdate($options);
$update->setSoapHeaderAuthenticationSoapHeader(new \dgsoft\StructType\DgAuthenticationSoapHeader());
$update->setSoapHeaderGenericSoapHeader(new \dgsoft\StructType\DgGenericSoapHeader());
/**
 * Sample call for UpdateUser operation/method
 */
if ($update->UpdateUser(new \dgsoft\StructType\DgUpdateUser()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
