<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleVendorAvailabilityTypeVehAvails StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleVendorAvailabilityTypeVehAvails extends AbstractStructBase
{
    /**
     * The VehAvail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail[]
     */
    public $VehAvail;
    /**
     * The RateCategory
     * @var string
     */
    public $RateCategory;
    /**
     * The RatePeriod
     * @var string
     */
    public $RatePeriod;
    /**
     * Constructor method for VehicleVendorAvailabilityTypeVehAvails
     * @uses DgVehicleVendorAvailabilityTypeVehAvails::setVehAvail()
     * @uses DgVehicleVendorAvailabilityTypeVehAvails::setRateCategory()
     * @uses DgVehicleVendorAvailabilityTypeVehAvails::setRatePeriod()
     * @param \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail[] $vehAvail
     * @param string $rateCategory
     * @param string $ratePeriod
     */
    public function __construct(array $vehAvail = array(), $rateCategory = null, $ratePeriod = null)
    {
        $this
            ->setVehAvail($vehAvail)
            ->setRateCategory($rateCategory)
            ->setRatePeriod($ratePeriod);
    }
    /**
     * Get VehAvail value
     * @return \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail[]|null
     */
    public function getVehAvail()
    {
        return $this->VehAvail;
    }
    /**
     * Set VehAvail value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail[] $vehAvail
     * @return \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvails
     */
    public function setVehAvail(array $vehAvail = array())
    {
        foreach ($vehAvail as $vehicleVendorAvailabilityTypeVehAvailsVehAvailItem) {
            // validation for constraint: itemType
            if (!$vehicleVendorAvailabilityTypeVehAvailsVehAvailItem instanceof \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail) {
                throw new \InvalidArgumentException(sprintf('The VehAvail property can only contain items of \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail, "%s" given', is_object($vehicleVendorAvailabilityTypeVehAvailsVehAvailItem) ? get_class($vehicleVendorAvailabilityTypeVehAvailsVehAvailItem) : gettype($vehicleVendorAvailabilityTypeVehAvailsVehAvailItem)), __LINE__);
            }
        }
        $this->VehAvail = $vehAvail;
        return $this;
    }
    /**
     * Add item to VehAvail value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail $item
     * @return \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvails
     */
    public function addToVehAvail(\dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail) {
            throw new \InvalidArgumentException(sprintf('The VehAvail property can only contain items of \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehAvail[] = $item;
        return $this;
    }
    /**
     * Get RateCategory value
     * @return string|null
     */
    public function getRateCategory()
    {
        return $this->RateCategory;
    }
    /**
     * Set RateCategory value
     * @param string $rateCategory
     * @return \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvails
     */
    public function setRateCategory($rateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategory) && !is_string($rateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateCategory)), __LINE__);
        }
        $this->RateCategory = $rateCategory;
        return $this;
    }
    /**
     * Get RatePeriod value
     * @return string|null
     */
    public function getRatePeriod()
    {
        return $this->RatePeriod;
    }
    /**
     * Set RatePeriod value
     * @uses \dgsoft\EnumType\DgRateQualifierTypeRatePeriod::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateQualifierTypeRatePeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ratePeriod
     * @return \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvails
     */
    public function setRatePeriod($ratePeriod = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateQualifierTypeRatePeriod::valueIsValid($ratePeriod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ratePeriod, implode(', ', \dgsoft\EnumType\DgRateQualifierTypeRatePeriod::getValidValues())), __LINE__);
        }
        $this->RatePeriod = $ratePeriod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleVendorAvailabilityTypeVehAvails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
