<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleVendorAddressType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleVendorAddressType extends DgAddressType
{
    /**
     * The OpeningHour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpeningHour;
    /**
     * The ClosingHour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClosingHour;
    /**
     * The FaxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The OfficePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfficePhone;
    /**
     * Constructor method for VehicleVendorAddressType
     * @uses DgVehicleVendorAddressType::setOpeningHour()
     * @uses DgVehicleVendorAddressType::setClosingHour()
     * @uses DgVehicleVendorAddressType::setFaxNumber()
     * @uses DgVehicleVendorAddressType::setOfficePhone()
     * @param string $openingHour
     * @param string $closingHour
     * @param string $faxNumber
     * @param string $officePhone
     */
    public function __construct($openingHour = null, $closingHour = null, $faxNumber = null, $officePhone = null)
    {
        $this
            ->setOpeningHour($openingHour)
            ->setClosingHour($closingHour)
            ->setFaxNumber($faxNumber)
            ->setOfficePhone($officePhone);
    }
    /**
     * Get OpeningHour value
     * @return string|null
     */
    public function getOpeningHour()
    {
        return $this->OpeningHour;
    }
    /**
     * Set OpeningHour value
     * @param string $openingHour
     * @return \dgsoft\StructType\DgVehicleVendorAddressType
     */
    public function setOpeningHour($openingHour = null)
    {
        // validation for constraint: string
        if (!is_null($openingHour) && !is_string($openingHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openingHour)), __LINE__);
        }
        $this->OpeningHour = $openingHour;
        return $this;
    }
    /**
     * Get ClosingHour value
     * @return string|null
     */
    public function getClosingHour()
    {
        return $this->ClosingHour;
    }
    /**
     * Set ClosingHour value
     * @param string $closingHour
     * @return \dgsoft\StructType\DgVehicleVendorAddressType
     */
    public function setClosingHour($closingHour = null)
    {
        // validation for constraint: string
        if (!is_null($closingHour) && !is_string($closingHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closingHour)), __LINE__);
        }
        $this->ClosingHour = $closingHour;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \dgsoft\StructType\DgVehicleVendorAddressType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get OfficePhone value
     * @return string|null
     */
    public function getOfficePhone()
    {
        return $this->OfficePhone;
    }
    /**
     * Set OfficePhone value
     * @param string $officePhone
     * @return \dgsoft\StructType\DgVehicleVendorAddressType
     */
    public function setOfficePhone($officePhone = null)
    {
        // validation for constraint: string
        if (!is_null($officePhone) && !is_string($officePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officePhone)), __LINE__);
        }
        $this->OfficePhone = $officePhone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleVendorAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
