<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleSegmentCoreType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleSegmentCoreType extends AbstractStructBase
{
    /**
     * The ConfID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $ConfID;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $Vendor;
    /**
     * The VehRentalCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public $VehRentalCore;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleType
     */
    public $Vehicle;
    /**
     * The RentalRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalRateType
     */
    public $RentalRate;
    /**
     * The PricedEquips
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType
     */
    public $PricedEquips;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1
     */
    public $Fees;
    /**
     * The TotalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleSegmentCoreTypeTotalCharge
     */
    public $TotalCharge;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The IndexNumber
     * @var int
     */
    public $IndexNumber;
    /**
     * Constructor method for VehicleSegmentCoreType
     * @uses DgVehicleSegmentCoreType::setConfID()
     * @uses DgVehicleSegmentCoreType::setVendor()
     * @uses DgVehicleSegmentCoreType::setVehRentalCore()
     * @uses DgVehicleSegmentCoreType::setVehicle()
     * @uses DgVehicleSegmentCoreType::setRentalRate()
     * @uses DgVehicleSegmentCoreType::setPricedEquips()
     * @uses DgVehicleSegmentCoreType::setFees()
     * @uses DgVehicleSegmentCoreType::setTotalCharge()
     * @uses DgVehicleSegmentCoreType::setTPA_Extensions()
     * @uses DgVehicleSegmentCoreType::setIndexNumber()
     * @param \dgsoft\StructType\DgUniqueID_Type[] $confID
     * @param \dgsoft\StructType\DgCompanyNameType $vendor
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @param \dgsoft\StructType\DgVehicleType $vehicle
     * @param \dgsoft\StructType\DgVehicleRentalRateType $rentalRate
     * @param \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees
     * @param \dgsoft\StructType\DgVehicleSegmentCoreTypeTotalCharge $totalCharge
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param int $indexNumber
     */
    public function __construct(array $confID = array(), \dgsoft\StructType\DgCompanyNameType $vendor = null, \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null, \dgsoft\StructType\DgVehicleType $vehicle = null, \dgsoft\StructType\DgVehicleRentalRateType $rentalRate = null, \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips = null, \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees = null, \dgsoft\StructType\DgVehicleSegmentCoreTypeTotalCharge $totalCharge = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $indexNumber = null)
    {
        $this
            ->setConfID($confID)
            ->setVendor($vendor)
            ->setVehRentalCore($vehRentalCore)
            ->setVehicle($vehicle)
            ->setRentalRate($rentalRate)
            ->setPricedEquips($pricedEquips)
            ->setFees($fees)
            ->setTotalCharge($totalCharge)
            ->setTPA_Extensions($tPA_Extensions)
            ->setIndexNumber($indexNumber);
    }
    /**
     * Get ConfID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getConfID()
    {
        return $this->ConfID;
    }
    /**
     * Set ConfID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $confID
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setConfID(array $confID = array())
    {
        foreach ($confID as $vehicleSegmentCoreTypeConfIDItem) {
            // validation for constraint: itemType
            if (!$vehicleSegmentCoreTypeConfIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The ConfID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($vehicleSegmentCoreTypeConfIDItem) ? get_class($vehicleSegmentCoreTypeConfIDItem) : gettype($vehicleSegmentCoreTypeConfIDItem)), __LINE__);
            }
        }
        $this->ConfID = $confID;
        return $this;
    }
    /**
     * Add item to ConfID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function addToConfID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The ConfID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConfID[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \dgsoft\StructType\DgCompanyNameType $vendor
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setVendor(\dgsoft\StructType\DgCompanyNameType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get VehRentalCore value
     * @return \dgsoft\StructType\DgVehicleRentalCoreType|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setVehRentalCore(\dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \dgsoft\StructType\DgVehicleType|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \dgsoft\StructType\DgVehicleType $vehicle
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setVehicle(\dgsoft\StructType\DgVehicleType $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get RentalRate value
     * @return \dgsoft\StructType\DgVehicleRentalRateType|null
     */
    public function getRentalRate()
    {
        return $this->RentalRate;
    }
    /**
     * Set RentalRate value
     * @param \dgsoft\StructType\DgVehicleRentalRateType $rentalRate
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setRentalRate(\dgsoft\StructType\DgVehicleRentalRateType $rentalRate = null)
    {
        $this->RentalRate = $rentalRate;
        return $this;
    }
    /**
     * Get PricedEquips value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType|null
     */
    public function getPricedEquips()
    {
        return $this->PricedEquips;
    }
    /**
     * Set PricedEquips value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setPricedEquips(\dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips = null)
    {
        $this->PricedEquips = $pricedEquips;
        return $this;
    }
    /**
     * Get Fees value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setFees(\dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \dgsoft\StructType\DgVehicleSegmentCoreTypeTotalCharge|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \dgsoft\StructType\DgVehicleSegmentCoreTypeTotalCharge $totalCharge
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setTotalCharge(\dgsoft\StructType\DgVehicleSegmentCoreTypeTotalCharge $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !is_numeric($indexNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleSegmentCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
