<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleSegmentAdditionalInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleSegmentAdditionalInfoType extends AbstractStructBase
{
    /**
     * The PaymentRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfMonetaryRuleType
     */
    public $PaymentRules;
    /**
     * The RentalPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentDetailType[]
     */
    public $RentalPaymentAmount;
    /**
     * The PricedCoverages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCoveragePricedType
     */
    public $PricedCoverages;
    /**
     * The PricedOffLocService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOffLocationServicePricedType[]
     */
    public $PricedOffLocService;
    /**
     * The VendorMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFormattedTextType
     */
    public $VendorMessages;
    /**
     * The LocationDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleLocationDetailsType[]
     */
    public $LocationDetails;
    /**
     * The TourInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleTourInfoType
     */
    public $TourInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The WrittenConfInd
     * @var bool
     */
    public $WrittenConfInd;
    /**
     * Constructor method for VehicleSegmentAdditionalInfoType
     * @uses DgVehicleSegmentAdditionalInfoType::setPaymentRules()
     * @uses DgVehicleSegmentAdditionalInfoType::setRentalPaymentAmount()
     * @uses DgVehicleSegmentAdditionalInfoType::setPricedCoverages()
     * @uses DgVehicleSegmentAdditionalInfoType::setPricedOffLocService()
     * @uses DgVehicleSegmentAdditionalInfoType::setVendorMessages()
     * @uses DgVehicleSegmentAdditionalInfoType::setLocationDetails()
     * @uses DgVehicleSegmentAdditionalInfoType::setTourInfo()
     * @uses DgVehicleSegmentAdditionalInfoType::setTPA_Extensions()
     * @uses DgVehicleSegmentAdditionalInfoType::setWrittenConfInd()
     * @param \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules
     * @param \dgsoft\StructType\DgPaymentDetailType[] $rentalPaymentAmount
     * @param \dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages
     * @param \dgsoft\StructType\DgOffLocationServicePricedType[] $pricedOffLocService
     * @param \dgsoft\ArrayType\DgArrayOfFormattedTextType $vendorMessages
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType[] $locationDetails
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param bool $writtenConfInd
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules = null, array $rentalPaymentAmount = array(), \dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages = null, array $pricedOffLocService = array(), \dgsoft\ArrayType\DgArrayOfFormattedTextType $vendorMessages = null, array $locationDetails = array(), \dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $writtenConfInd = null)
    {
        $this
            ->setPaymentRules($paymentRules)
            ->setRentalPaymentAmount($rentalPaymentAmount)
            ->setPricedCoverages($pricedCoverages)
            ->setPricedOffLocService($pricedOffLocService)
            ->setVendorMessages($vendorMessages)
            ->setLocationDetails($locationDetails)
            ->setTourInfo($tourInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setWrittenConfInd($writtenConfInd);
    }
    /**
     * Get PaymentRules value
     * @return \dgsoft\ArrayType\DgArrayOfMonetaryRuleType|null
     */
    public function getPaymentRules()
    {
        return $this->PaymentRules;
    }
    /**
     * Set PaymentRules value
     * @param \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setPaymentRules(\dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules = null)
    {
        $this->PaymentRules = $paymentRules;
        return $this;
    }
    /**
     * Get RentalPaymentAmount value
     * @return \dgsoft\StructType\DgPaymentDetailType[]|null
     */
    public function getRentalPaymentAmount()
    {
        return $this->RentalPaymentAmount;
    }
    /**
     * Set RentalPaymentAmount value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentDetailType[] $rentalPaymentAmount
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setRentalPaymentAmount(array $rentalPaymentAmount = array())
    {
        foreach ($rentalPaymentAmount as $vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem) {
            // validation for constraint: itemType
            if (!$vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem instanceof \dgsoft\StructType\DgPaymentDetailType) {
                throw new \InvalidArgumentException(sprintf('The RentalPaymentAmount property can only contain items of \dgsoft\StructType\DgPaymentDetailType, "%s" given', is_object($vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem) ? get_class($vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem) : gettype($vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem)), __LINE__);
            }
        }
        $this->RentalPaymentAmount = $rentalPaymentAmount;
        return $this;
    }
    /**
     * Add item to RentalPaymentAmount value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentDetailType $item
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function addToRentalPaymentAmount(\dgsoft\StructType\DgPaymentDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentDetailType) {
            throw new \InvalidArgumentException(sprintf('The RentalPaymentAmount property can only contain items of \dgsoft\StructType\DgPaymentDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RentalPaymentAmount[] = $item;
        return $this;
    }
    /**
     * Get PricedCoverages value
     * @return \dgsoft\ArrayType\DgArrayOfCoveragePricedType|null
     */
    public function getPricedCoverages()
    {
        return $this->PricedCoverages;
    }
    /**
     * Set PricedCoverages value
     * @param \dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setPricedCoverages(\dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages = null)
    {
        $this->PricedCoverages = $pricedCoverages;
        return $this;
    }
    /**
     * Get PricedOffLocService value
     * @return \dgsoft\StructType\DgOffLocationServicePricedType[]|null
     */
    public function getPricedOffLocService()
    {
        return $this->PricedOffLocService;
    }
    /**
     * Set PricedOffLocService value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServicePricedType[] $pricedOffLocService
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setPricedOffLocService(array $pricedOffLocService = array())
    {
        foreach ($pricedOffLocService as $vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem) {
            // validation for constraint: itemType
            if (!$vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem instanceof \dgsoft\StructType\DgOffLocationServicePricedType) {
                throw new \InvalidArgumentException(sprintf('The PricedOffLocService property can only contain items of \dgsoft\StructType\DgOffLocationServicePricedType, "%s" given', is_object($vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem) ? get_class($vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem) : gettype($vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem)), __LINE__);
            }
        }
        $this->PricedOffLocService = $pricedOffLocService;
        return $this;
    }
    /**
     * Add item to PricedOffLocService value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServicePricedType $item
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function addToPricedOffLocService(\dgsoft\StructType\DgOffLocationServicePricedType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOffLocationServicePricedType) {
            throw new \InvalidArgumentException(sprintf('The PricedOffLocService property can only contain items of \dgsoft\StructType\DgOffLocationServicePricedType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PricedOffLocService[] = $item;
        return $this;
    }
    /**
     * Get VendorMessages value
     * @return \dgsoft\ArrayType\DgArrayOfFormattedTextType|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param \dgsoft\ArrayType\DgArrayOfFormattedTextType $vendorMessages
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setVendorMessages(\dgsoft\ArrayType\DgArrayOfFormattedTextType $vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get LocationDetails value
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType[]|null
     */
    public function getLocationDetails()
    {
        return $this->LocationDetails;
    }
    /**
     * Set LocationDetails value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType[] $locationDetails
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setLocationDetails(array $locationDetails = array())
    {
        foreach ($locationDetails as $vehicleSegmentAdditionalInfoTypeLocationDetailsItem) {
            // validation for constraint: itemType
            if (!$vehicleSegmentAdditionalInfoTypeLocationDetailsItem instanceof \dgsoft\StructType\DgVehicleLocationDetailsType) {
                throw new \InvalidArgumentException(sprintf('The LocationDetails property can only contain items of \dgsoft\StructType\DgVehicleLocationDetailsType, "%s" given', is_object($vehicleSegmentAdditionalInfoTypeLocationDetailsItem) ? get_class($vehicleSegmentAdditionalInfoTypeLocationDetailsItem) : gettype($vehicleSegmentAdditionalInfoTypeLocationDetailsItem)), __LINE__);
            }
        }
        $this->LocationDetails = $locationDetails;
        return $this;
    }
    /**
     * Add item to LocationDetails value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType $item
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function addToLocationDetails(\dgsoft\StructType\DgVehicleLocationDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleLocationDetailsType) {
            throw new \InvalidArgumentException(sprintf('The LocationDetails property can only contain items of \dgsoft\StructType\DgVehicleLocationDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LocationDetails[] = $item;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return \dgsoft\StructType\DgVehicleTourInfoType|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setTourInfo(\dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get WrittenConfInd value
     * @return bool|null
     */
    public function getWrittenConfInd()
    {
        return $this->WrittenConfInd;
    }
    /**
     * Set WrittenConfInd value
     * @param bool $writtenConfInd
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public function setWrittenConfInd($writtenConfInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($writtenConfInd) && !is_bool($writtenConfInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($writtenConfInd)), __LINE__);
        }
        $this->WrittenConfInd = $writtenConfInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
