<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalRateTypePickupReturnRule StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleRentalRateTypePickupReturnRule extends AbstractStructBase
{
    /**
     * The DayOfWeek
     * @var string
     */
    public $DayOfWeek;
    /**
     * The Time
     * @var string
     */
    public $Time;
    /**
     * The RuleType
     * @var string
     */
    public $RuleType;
    /**
     * Constructor method for VehicleRentalRateTypePickupReturnRule
     * @uses DgVehicleRentalRateTypePickupReturnRule::setDayOfWeek()
     * @uses DgVehicleRentalRateTypePickupReturnRule::setTime()
     * @uses DgVehicleRentalRateTypePickupReturnRule::setRuleType()
     * @param string $dayOfWeek
     * @param string $time
     * @param string $ruleType
     */
    public function __construct($dayOfWeek = null, $time = null, $ruleType = null)
    {
        $this
            ->setDayOfWeek($dayOfWeek)
            ->setTime($time)
            ->setRuleType($ruleType);
    }
    /**
     * Get DayOfWeek value
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return $this->DayOfWeek;
    }
    /**
     * Set DayOfWeek value
     * @uses \dgsoft\EnumType\DgDayOfWeekType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfWeek
     * @return \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDayOfWeekType::valueIsValid($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfWeek, implode(', ', \dgsoft\EnumType\DgDayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get RuleType value
     * @return string|null
     */
    public function getRuleType()
    {
        return $this->RuleType;
    }
    /**
     * Set RuleType value
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypePickupReturnRuleRuleType::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypePickupReturnRuleRuleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ruleType
     * @return \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule
     */
    public function setRuleType($ruleType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleRentalRateTypePickupReturnRuleRuleType::valueIsValid($ruleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ruleType, implode(', ', \dgsoft\EnumType\DgVehicleRentalRateTypePickupReturnRuleRuleType::getValidValues())), __LINE__);
        }
        $this->RuleType = $ruleType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
