<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalRateType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleRentalRateType extends AbstractStructBase
{
    /**
     * The CarTaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount
     */
    public $CarTaxes;
    /**
     * The CarCompanyAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleVendorAddressType
     */
    public $CarCompanyAddresses;
    /**
     * The Remarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSpecialRemarkType
     */
    public $Remarks;
    /**
     * The CarModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarModel;
    /**
     * The RateDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance[]
     */
    public $RateDistance;
    /**
     * The VehicleCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType
     */
    public $VehicleCharges;
    /**
     * The RateQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRateQualifierType
     */
    public $RateQualifier;
    /**
     * The RateRestrictions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public $RateRestrictions;
    /**
     * The RateGuarantee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee
     */
    public $RateGuarantee;
    /**
     * The PickupReturnRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule[]
     */
    public $PickupReturnRule;
    /**
     * Constructor method for VehicleRentalRateType
     * @uses DgVehicleRentalRateType::setCarTaxes()
     * @uses DgVehicleRentalRateType::setCarCompanyAddresses()
     * @uses DgVehicleRentalRateType::setRemarks()
     * @uses DgVehicleRentalRateType::setCarModel()
     * @uses DgVehicleRentalRateType::setRateDistance()
     * @uses DgVehicleRentalRateType::setVehicleCharges()
     * @uses DgVehicleRentalRateType::setRateQualifier()
     * @uses DgVehicleRentalRateType::setRateRestrictions()
     * @uses DgVehicleRentalRateType::setRateGuarantee()
     * @uses DgVehicleRentalRateType::setPickupReturnRule()
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount $carTaxes
     * @param \dgsoft\ArrayType\DgArrayOfVehicleVendorAddressType $carCompanyAddresses
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRemarkType $remarks
     * @param string $carModel
     * @param \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance[] $rateDistance
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges
     * @param \dgsoft\StructType\DgRateQualifierType $rateQualifier
     * @param \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions $rateRestrictions
     * @param \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee $rateGuarantee
     * @param \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule[] $pickupReturnRule
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount $carTaxes = null, \dgsoft\ArrayType\DgArrayOfVehicleVendorAddressType $carCompanyAddresses = null, \dgsoft\ArrayType\DgArrayOfSpecialRemarkType $remarks = null, $carModel = null, array $rateDistance = array(), \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges = null, \dgsoft\StructType\DgRateQualifierType $rateQualifier = null, \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions $rateRestrictions = null, \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee $rateGuarantee = null, array $pickupReturnRule = array())
    {
        $this
            ->setCarTaxes($carTaxes)
            ->setCarCompanyAddresses($carCompanyAddresses)
            ->setRemarks($remarks)
            ->setCarModel($carModel)
            ->setRateDistance($rateDistance)
            ->setVehicleCharges($vehicleCharges)
            ->setRateQualifier($rateQualifier)
            ->setRateRestrictions($rateRestrictions)
            ->setRateGuarantee($rateGuarantee)
            ->setPickupReturnRule($pickupReturnRule);
    }
    /**
     * Get CarTaxes value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount|null
     */
    public function getCarTaxes()
    {
        return $this->CarTaxes;
    }
    /**
     * Set CarTaxes value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount $carTaxes
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setCarTaxes(\dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount $carTaxes = null)
    {
        $this->CarTaxes = $carTaxes;
        return $this;
    }
    /**
     * Get CarCompanyAddresses value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleVendorAddressType|null
     */
    public function getCarCompanyAddresses()
    {
        return $this->CarCompanyAddresses;
    }
    /**
     * Set CarCompanyAddresses value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleVendorAddressType $carCompanyAddresses
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setCarCompanyAddresses(\dgsoft\ArrayType\DgArrayOfVehicleVendorAddressType $carCompanyAddresses = null)
    {
        $this->CarCompanyAddresses = $carCompanyAddresses;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRemarkType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRemarkType $remarks
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setRemarks(\dgsoft\ArrayType\DgArrayOfSpecialRemarkType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get CarModel value
     * @return string|null
     */
    public function getCarModel()
    {
        return $this->CarModel;
    }
    /**
     * Set CarModel value
     * @param string $carModel
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setCarModel($carModel = null)
    {
        // validation for constraint: string
        if (!is_null($carModel) && !is_string($carModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carModel)), __LINE__);
        }
        $this->CarModel = $carModel;
        return $this;
    }
    /**
     * Get RateDistance value
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance[]|null
     */
    public function getRateDistance()
    {
        return $this->RateDistance;
    }
    /**
     * Set RateDistance value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance[] $rateDistance
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setRateDistance(array $rateDistance = array())
    {
        foreach ($rateDistance as $vehicleRentalRateTypeRateDistanceItem) {
            // validation for constraint: itemType
            if (!$vehicleRentalRateTypeRateDistanceItem instanceof \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance) {
                throw new \InvalidArgumentException(sprintf('The RateDistance property can only contain items of \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance, "%s" given', is_object($vehicleRentalRateTypeRateDistanceItem) ? get_class($vehicleRentalRateTypeRateDistanceItem) : gettype($vehicleRentalRateTypeRateDistanceItem)), __LINE__);
            }
        }
        $this->RateDistance = $rateDistance;
        return $this;
    }
    /**
     * Add item to RateDistance value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance $item
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function addToRateDistance(\dgsoft\StructType\DgVehicleRentalRateTypeRateDistance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance) {
            throw new \InvalidArgumentException(sprintf('The RateDistance property can only contain items of \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RateDistance[] = $item;
        return $this;
    }
    /**
     * Get VehicleCharges value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType|null
     */
    public function getVehicleCharges()
    {
        return $this->VehicleCharges;
    }
    /**
     * Set VehicleCharges value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setVehicleCharges(\dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges = null)
    {
        $this->VehicleCharges = $vehicleCharges;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \dgsoft\StructType\DgRateQualifierType|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param \dgsoft\StructType\DgRateQualifierType $rateQualifier
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setRateQualifier(\dgsoft\StructType\DgRateQualifierType $rateQualifier = null)
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get RateRestrictions value
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions|null
     */
    public function getRateRestrictions()
    {
        return $this->RateRestrictions;
    }
    /**
     * Set RateRestrictions value
     * @param \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions $rateRestrictions
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setRateRestrictions(\dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions $rateRestrictions = null)
    {
        $this->RateRestrictions = $rateRestrictions;
        return $this;
    }
    /**
     * Get RateGuarantee value
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee|null
     */
    public function getRateGuarantee()
    {
        return $this->RateGuarantee;
    }
    /**
     * Set RateGuarantee value
     * @param \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee $rateGuarantee
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setRateGuarantee(\dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee $rateGuarantee = null)
    {
        $this->RateGuarantee = $rateGuarantee;
        return $this;
    }
    /**
     * Get PickupReturnRule value
     * @return \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule[]|null
     */
    public function getPickupReturnRule()
    {
        return $this->PickupReturnRule;
    }
    /**
     * Set PickupReturnRule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule[] $pickupReturnRule
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function setPickupReturnRule(array $pickupReturnRule = array())
    {
        foreach ($pickupReturnRule as $vehicleRentalRateTypePickupReturnRuleItem) {
            // validation for constraint: itemType
            if (!$vehicleRentalRateTypePickupReturnRuleItem instanceof \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule) {
                throw new \InvalidArgumentException(sprintf('The PickupReturnRule property can only contain items of \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule, "%s" given', is_object($vehicleRentalRateTypePickupReturnRuleItem) ? get_class($vehicleRentalRateTypePickupReturnRuleItem) : gettype($vehicleRentalRateTypePickupReturnRuleItem)), __LINE__);
            }
        }
        $this->PickupReturnRule = $pickupReturnRule;
        return $this;
    }
    /**
     * Add item to PickupReturnRule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule $item
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public function addToPickupReturnRule(\dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule) {
            throw new \InvalidArgumentException(sprintf('The PickupReturnRule property can only contain items of \dgsoft\StructType\DgVehicleRentalRateTypePickupReturnRule, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PickupReturnRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleRentalRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
