<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalCoreType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleRentalCoreType extends AbstractStructBase
{
    /**
     * The PickupAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressType
     */
    public $PickupAddress;
    /**
     * The PickUpLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation[]
     */
    public $PickUpLocation;
    /**
     * The ReturnLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalCoreTypeReturnLocation
     */
    public $ReturnLocation;
    /**
     * The PickUpDateTime
     * @var string
     */
    public $PickUpDateTime;
    /**
     * The ReturnDateTime
     * @var string
     */
    public $ReturnDateTime;
    /**
     * The StartChargesDateTime
     * @var string
     */
    public $StartChargesDateTime;
    /**
     * The StopChargesDateTime
     * @var string
     */
    public $StopChargesDateTime;
    /**
     * The OneWayIndicator
     * @var bool
     */
    public $OneWayIndicator;
    /**
     * The MultiIslandRentalDays
     * @var int
     */
    public $MultiIslandRentalDays;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The DistUnitName
     * @var string
     */
    public $DistUnitName;
    /**
     * Constructor method for VehicleRentalCoreType
     * @uses DgVehicleRentalCoreType::setPickupAddress()
     * @uses DgVehicleRentalCoreType::setPickUpLocation()
     * @uses DgVehicleRentalCoreType::setReturnLocation()
     * @uses DgVehicleRentalCoreType::setPickUpDateTime()
     * @uses DgVehicleRentalCoreType::setReturnDateTime()
     * @uses DgVehicleRentalCoreType::setStartChargesDateTime()
     * @uses DgVehicleRentalCoreType::setStopChargesDateTime()
     * @uses DgVehicleRentalCoreType::setOneWayIndicator()
     * @uses DgVehicleRentalCoreType::setMultiIslandRentalDays()
     * @uses DgVehicleRentalCoreType::setQuantity()
     * @uses DgVehicleRentalCoreType::setDistUnitName()
     * @param \dgsoft\StructType\DgAddressType $pickupAddress
     * @param \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation[] $pickUpLocation
     * @param \dgsoft\StructType\DgVehicleRentalCoreTypeReturnLocation $returnLocation
     * @param string $pickUpDateTime
     * @param string $returnDateTime
     * @param string $startChargesDateTime
     * @param string $stopChargesDateTime
     * @param bool $oneWayIndicator
     * @param int $multiIslandRentalDays
     * @param int $quantity
     * @param string $distUnitName
     */
    public function __construct(\dgsoft\StructType\DgAddressType $pickupAddress = null, array $pickUpLocation = array(), \dgsoft\StructType\DgVehicleRentalCoreTypeReturnLocation $returnLocation = null, $pickUpDateTime = null, $returnDateTime = null, $startChargesDateTime = null, $stopChargesDateTime = null, $oneWayIndicator = null, $multiIslandRentalDays = null, $quantity = null, $distUnitName = null)
    {
        $this
            ->setPickupAddress($pickupAddress)
            ->setPickUpLocation($pickUpLocation)
            ->setReturnLocation($returnLocation)
            ->setPickUpDateTime($pickUpDateTime)
            ->setReturnDateTime($returnDateTime)
            ->setStartChargesDateTime($startChargesDateTime)
            ->setStopChargesDateTime($stopChargesDateTime)
            ->setOneWayIndicator($oneWayIndicator)
            ->setMultiIslandRentalDays($multiIslandRentalDays)
            ->setQuantity($quantity)
            ->setDistUnitName($distUnitName);
    }
    /**
     * Get PickupAddress value
     * @return \dgsoft\StructType\DgAddressType|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \dgsoft\StructType\DgAddressType $pickupAddress
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setPickupAddress(\dgsoft\StructType\DgAddressType $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get PickUpLocation value
     * @return \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation[]|null
     */
    public function getPickUpLocation()
    {
        return $this->PickUpLocation;
    }
    /**
     * Set PickUpLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation[] $pickUpLocation
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setPickUpLocation(array $pickUpLocation = array())
    {
        foreach ($pickUpLocation as $vehicleRentalCoreTypePickUpLocationItem) {
            // validation for constraint: itemType
            if (!$vehicleRentalCoreTypePickUpLocationItem instanceof \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation) {
                throw new \InvalidArgumentException(sprintf('The PickUpLocation property can only contain items of \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation, "%s" given', is_object($vehicleRentalCoreTypePickUpLocationItem) ? get_class($vehicleRentalCoreTypePickUpLocationItem) : gettype($vehicleRentalCoreTypePickUpLocationItem)), __LINE__);
            }
        }
        $this->PickUpLocation = $pickUpLocation;
        return $this;
    }
    /**
     * Add item to PickUpLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation $item
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function addToPickUpLocation(\dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation) {
            throw new \InvalidArgumentException(sprintf('The PickUpLocation property can only contain items of \dgsoft\StructType\DgVehicleRentalCoreTypePickUpLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PickUpLocation[] = $item;
        return $this;
    }
    /**
     * Get ReturnLocation value
     * @return \dgsoft\StructType\DgVehicleRentalCoreTypeReturnLocation|null
     */
    public function getReturnLocation()
    {
        return $this->ReturnLocation;
    }
    /**
     * Set ReturnLocation value
     * @param \dgsoft\StructType\DgVehicleRentalCoreTypeReturnLocation $returnLocation
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setReturnLocation(\dgsoft\StructType\DgVehicleRentalCoreTypeReturnLocation $returnLocation = null)
    {
        $this->ReturnLocation = $returnLocation;
        return $this;
    }
    /**
     * Get PickUpDateTime value
     * @return string|null
     */
    public function getPickUpDateTime()
    {
        return $this->PickUpDateTime;
    }
    /**
     * Set PickUpDateTime value
     * @param string $pickUpDateTime
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setPickUpDateTime($pickUpDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpDateTime) && !is_string($pickUpDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickUpDateTime)), __LINE__);
        }
        $this->PickUpDateTime = $pickUpDateTime;
        return $this;
    }
    /**
     * Get ReturnDateTime value
     * @return string|null
     */
    public function getReturnDateTime()
    {
        return $this->ReturnDateTime;
    }
    /**
     * Set ReturnDateTime value
     * @param string $returnDateTime
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setReturnDateTime($returnDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($returnDateTime) && !is_string($returnDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnDateTime)), __LINE__);
        }
        $this->ReturnDateTime = $returnDateTime;
        return $this;
    }
    /**
     * Get StartChargesDateTime value
     * @return string|null
     */
    public function getStartChargesDateTime()
    {
        return $this->StartChargesDateTime;
    }
    /**
     * Set StartChargesDateTime value
     * @param string $startChargesDateTime
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setStartChargesDateTime($startChargesDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startChargesDateTime) && !is_string($startChargesDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startChargesDateTime)), __LINE__);
        }
        $this->StartChargesDateTime = $startChargesDateTime;
        return $this;
    }
    /**
     * Get StopChargesDateTime value
     * @return string|null
     */
    public function getStopChargesDateTime()
    {
        return $this->StopChargesDateTime;
    }
    /**
     * Set StopChargesDateTime value
     * @param string $stopChargesDateTime
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setStopChargesDateTime($stopChargesDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($stopChargesDateTime) && !is_string($stopChargesDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopChargesDateTime)), __LINE__);
        }
        $this->StopChargesDateTime = $stopChargesDateTime;
        return $this;
    }
    /**
     * Get OneWayIndicator value
     * @return bool|null
     */
    public function getOneWayIndicator()
    {
        return $this->OneWayIndicator;
    }
    /**
     * Set OneWayIndicator value
     * @param bool $oneWayIndicator
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setOneWayIndicator($oneWayIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($oneWayIndicator) && !is_bool($oneWayIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($oneWayIndicator)), __LINE__);
        }
        $this->OneWayIndicator = $oneWayIndicator;
        return $this;
    }
    /**
     * Get MultiIslandRentalDays value
     * @return int|null
     */
    public function getMultiIslandRentalDays()
    {
        return $this->MultiIslandRentalDays;
    }
    /**
     * Set MultiIslandRentalDays value
     * @param int $multiIslandRentalDays
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setMultiIslandRentalDays($multiIslandRentalDays = null)
    {
        // validation for constraint: int
        if (!is_null($multiIslandRentalDays) && !is_numeric($multiIslandRentalDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($multiIslandRentalDays)), __LINE__);
        }
        $this->MultiIslandRentalDays = $multiIslandRentalDays;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get DistUnitName value
     * @return string|null
     */
    public function getDistUnitName()
    {
        return $this->DistUnitName;
    }
    /**
     * Set DistUnitName value
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distUnitName
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public function setDistUnitName($distUnitName = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid($distUnitName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distUnitName, implode(', ', \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->DistUnitName = $distUnitName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
