<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleLocationDetailsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleLocationDetailsType extends AbstractStructBase
{
    /**
     * The LocationOpeningHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationOpeningHour[]
     */
    public $LocationOpeningHours;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressInfoType[]
     */
    public $Address;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone[]
     */
    public $Telephone;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleLocationAdditionalDetailsType
     */
    public $AdditionalInfo;
    /**
     * The AtAirport
     * @var bool
     */
    public $AtAirport;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The LocationAgency
     * @var string
     */
    public $LocationAgency;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * The ExtendedLocationCode
     * @var string
     */
    public $ExtendedLocationCode;
    /**
     * The AssocAirportLocList
     * @var string[]
     */
    public $AssocAirportLocList;
    /**
     * Constructor method for VehicleLocationDetailsType
     * @uses DgVehicleLocationDetailsType::setLocationOpeningHours()
     * @uses DgVehicleLocationDetailsType::setAddress()
     * @uses DgVehicleLocationDetailsType::setTelephone()
     * @uses DgVehicleLocationDetailsType::setAdditionalInfo()
     * @uses DgVehicleLocationDetailsType::setAtAirport()
     * @uses DgVehicleLocationDetailsType::setCode()
     * @uses DgVehicleLocationDetailsType::setLocationAgency()
     * @uses DgVehicleLocationDetailsType::setName()
     * @uses DgVehicleLocationDetailsType::setCodeContext()
     * @uses DgVehicleLocationDetailsType::setExtendedLocationCode()
     * @uses DgVehicleLocationDetailsType::setAssocAirportLocList()
     * @param \dgsoft\StructType\DgLocationOpeningHour[] $locationOpeningHours
     * @param \dgsoft\StructType\DgAddressInfoType[] $address
     * @param \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone[] $telephone
     * @param \dgsoft\StructType\DgVehicleLocationAdditionalDetailsType $additionalInfo
     * @param bool $atAirport
     * @param string $code
     * @param string $locationAgency
     * @param string $name
     * @param string $codeContext
     * @param string $extendedLocationCode
     * @param string[] $assocAirportLocList
     */
    public function __construct(array $locationOpeningHours = array(), array $address = array(), array $telephone = array(), \dgsoft\StructType\DgVehicleLocationAdditionalDetailsType $additionalInfo = null, $atAirport = null, $code = null, $locationAgency = null, $name = null, $codeContext = null, $extendedLocationCode = null, array $assocAirportLocList = array())
    {
        $this
            ->setLocationOpeningHours($locationOpeningHours)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setAdditionalInfo($additionalInfo)
            ->setAtAirport($atAirport)
            ->setCode($code)
            ->setLocationAgency($locationAgency)
            ->setName($name)
            ->setCodeContext($codeContext)
            ->setExtendedLocationCode($extendedLocationCode)
            ->setAssocAirportLocList($assocAirportLocList);
    }
    /**
     * Get LocationOpeningHours value
     * @return \dgsoft\StructType\DgLocationOpeningHour[]|null
     */
    public function getLocationOpeningHours()
    {
        return $this->LocationOpeningHours;
    }
    /**
     * Set LocationOpeningHours value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLocationOpeningHour[] $locationOpeningHours
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setLocationOpeningHours(array $locationOpeningHours = array())
    {
        foreach ($locationOpeningHours as $vehicleLocationDetailsTypeLocationOpeningHoursItem) {
            // validation for constraint: itemType
            if (!$vehicleLocationDetailsTypeLocationOpeningHoursItem instanceof \dgsoft\StructType\DgLocationOpeningHour) {
                throw new \InvalidArgumentException(sprintf('The LocationOpeningHours property can only contain items of \dgsoft\StructType\DgLocationOpeningHour, "%s" given', is_object($vehicleLocationDetailsTypeLocationOpeningHoursItem) ? get_class($vehicleLocationDetailsTypeLocationOpeningHoursItem) : gettype($vehicleLocationDetailsTypeLocationOpeningHoursItem)), __LINE__);
            }
        }
        $this->LocationOpeningHours = $locationOpeningHours;
        return $this;
    }
    /**
     * Add item to LocationOpeningHours value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLocationOpeningHour $item
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function addToLocationOpeningHours(\dgsoft\StructType\DgLocationOpeningHour $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLocationOpeningHour) {
            throw new \InvalidArgumentException(sprintf('The LocationOpeningHours property can only contain items of \dgsoft\StructType\DgLocationOpeningHour, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LocationOpeningHours[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddressInfoType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType[] $address
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $vehicleLocationDetailsTypeAddressItem) {
            // validation for constraint: itemType
            if (!$vehicleLocationDetailsTypeAddressItem instanceof \dgsoft\StructType\DgAddressInfoType) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($vehicleLocationDetailsTypeAddressItem) ? get_class($vehicleLocationDetailsTypeAddressItem) : gettype($vehicleLocationDetailsTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType $item
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function addToAddress(\dgsoft\StructType\DgAddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone[] $telephone
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $vehicleLocationDetailsTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$vehicleLocationDetailsTypeTelephoneItem instanceof \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone, "%s" given', is_object($vehicleLocationDetailsTypeTelephoneItem) ? get_class($vehicleLocationDetailsTypeTelephoneItem) : gettype($vehicleLocationDetailsTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone $item
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function addToTelephone(\dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgVehicleLocationDetailsTypeTelephone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \dgsoft\StructType\DgVehicleLocationAdditionalDetailsType|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \dgsoft\StructType\DgVehicleLocationAdditionalDetailsType $additionalInfo
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setAdditionalInfo(\dgsoft\StructType\DgVehicleLocationAdditionalDetailsType $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get AtAirport value
     * @return bool|null
     */
    public function getAtAirport()
    {
        return $this->AtAirport;
    }
    /**
     * Set AtAirport value
     * @param bool $atAirport
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setAtAirport($atAirport = null)
    {
        // validation for constraint: boolean
        if (!is_null($atAirport) && !is_bool($atAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($atAirport)), __LINE__);
        }
        $this->AtAirport = $atAirport;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LocationAgency value
     * @return string|null
     */
    public function getLocationAgency()
    {
        return $this->LocationAgency;
    }
    /**
     * Set LocationAgency value
     * @param string $locationAgency
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setLocationAgency($locationAgency = null)
    {
        // validation for constraint: string
        if (!is_null($locationAgency) && !is_string($locationAgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationAgency)), __LINE__);
        }
        $this->LocationAgency = $locationAgency;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get ExtendedLocationCode value
     * @return string|null
     */
    public function getExtendedLocationCode()
    {
        return $this->ExtendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setExtendedLocationCode($extendedLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($extendedLocationCode) && !is_string($extendedLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extendedLocationCode)), __LINE__);
        }
        $this->ExtendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Get AssocAirportLocList value
     * @return string[]|null
     */
    public function getAssocAirportLocList()
    {
        return $this->AssocAirportLocList;
    }
    /**
     * Set AssocAirportLocList value
     * @throws \InvalidArgumentException
     * @param string[] $assocAirportLocList
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function setAssocAirportLocList(array $assocAirportLocList = array())
    {
        foreach ($assocAirportLocList as $vehicleLocationDetailsTypeAssocAirportLocListItem) {
            // validation for constraint: itemType
            if (!is_string($vehicleLocationDetailsTypeAssocAirportLocListItem)) {
                throw new \InvalidArgumentException(sprintf('The AssocAirportLocList property can only contain items of string, "%s" given', is_object($vehicleLocationDetailsTypeAssocAirportLocListItem) ? get_class($vehicleLocationDetailsTypeAssocAirportLocListItem) : gettype($vehicleLocationDetailsTypeAssocAirportLocListItem)), __LINE__);
            }
        }
        $this->AssocAirportLocList = $assocAirportLocList;
        return $this;
    }
    /**
     * Add item to AssocAirportLocList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public function addToAssocAirportLocList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AssocAirportLocList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AssocAirportLocList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
