<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEquipmentType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleEquipmentType extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The EquipType
     * @var string
     */
    public $EquipType;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Restriction
     * @var string
     */
    public $Restriction;
    /**
     * Constructor method for VehicleEquipmentType
     * @uses DgVehicleEquipmentType::setDescription()
     * @uses DgVehicleEquipmentType::setEquipType()
     * @uses DgVehicleEquipmentType::setQuantity()
     * @uses DgVehicleEquipmentType::setRestriction()
     * @param string $description
     * @param string $equipType
     * @param int $quantity
     * @param string $restriction
     */
    public function __construct($description = null, $equipType = null, $quantity = null, $restriction = null)
    {
        $this
            ->setDescription($description)
            ->setEquipType($equipType)
            ->setQuantity($quantity)
            ->setRestriction($restriction);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \dgsoft\StructType\DgVehicleEquipmentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get EquipType value
     * @return string|null
     */
    public function getEquipType()
    {
        return $this->EquipType;
    }
    /**
     * Set EquipType value
     * @param string $equipType
     * @return \dgsoft\StructType\DgVehicleEquipmentType
     */
    public function setEquipType($equipType = null)
    {
        // validation for constraint: string
        if (!is_null($equipType) && !is_string($equipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipType)), __LINE__);
        }
        $this->EquipType = $equipType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgVehicleEquipmentType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Restriction value
     * @return string|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * Set Restriction value
     * @uses \dgsoft\EnumType\DgEquipmentRestrictionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgEquipmentRestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restriction
     * @return \dgsoft\StructType\DgVehicleEquipmentType
     */
    public function setRestriction($restriction = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgEquipmentRestrictionType::valueIsValid($restriction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $restriction, implode(', ', \dgsoft\EnumType\DgEquipmentRestrictionType::getValidValues())), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleEquipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
