<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEquipmentPricedType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleEquipmentPricedType extends AbstractStructBase
{
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleEquipmentType
     */
    public $Equipment;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleChargeType
     */
    public $Charge;
    /**
     * The Required
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $Required;
    /**
     * Constructor method for VehicleEquipmentPricedType
     * @uses DgVehicleEquipmentPricedType::setEquipment()
     * @uses DgVehicleEquipmentPricedType::setCharge()
     * @uses DgVehicleEquipmentPricedType::setRequired()
     * @param \dgsoft\StructType\DgVehicleEquipmentType $equipment
     * @param \dgsoft\StructType\DgVehicleChargeType $charge
     * @param bool $required
     */
    public function __construct(\dgsoft\StructType\DgVehicleEquipmentType $equipment = null, \dgsoft\StructType\DgVehicleChargeType $charge = null, $required = false)
    {
        $this
            ->setEquipment($equipment)
            ->setCharge($charge)
            ->setRequired($required);
    }
    /**
     * Get Equipment value
     * @return \dgsoft\StructType\DgVehicleEquipmentType|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \dgsoft\StructType\DgVehicleEquipmentType $equipment
     * @return \dgsoft\StructType\DgVehicleEquipmentPricedType
     */
    public function setEquipment(\dgsoft\StructType\DgVehicleEquipmentType $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get Charge value
     * @return \dgsoft\StructType\DgVehicleChargeType|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \dgsoft\StructType\DgVehicleChargeType $charge
     * @return \dgsoft\StructType\DgVehicleEquipmentPricedType
     */
    public function setCharge(\dgsoft\StructType\DgVehicleChargeType $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \dgsoft\StructType\DgVehicleEquipmentPricedType
     */
    public function setRequired($required = false)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleEquipmentPricedType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
