<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleChargeTypeCalculation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleChargeTypeCalculation extends AbstractStructBase
{
    /**
     * The UnitCharge
     * @var float
     */
    public $UnitCharge;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Percentage
     * @var float
     */
    public $Percentage;
    /**
     * The Applicability
     * @var string
     */
    public $Applicability;
    /**
     * The MaxQuantity
     * @var int
     */
    public $MaxQuantity;
    /**
     * Constructor method for VehicleChargeTypeCalculation
     * @uses DgVehicleChargeTypeCalculation::setUnitCharge()
     * @uses DgVehicleChargeTypeCalculation::setUnitName()
     * @uses DgVehicleChargeTypeCalculation::setQuantity()
     * @uses DgVehicleChargeTypeCalculation::setPercentage()
     * @uses DgVehicleChargeTypeCalculation::setApplicability()
     * @uses DgVehicleChargeTypeCalculation::setMaxQuantity()
     * @param float $unitCharge
     * @param string $unitName
     * @param int $quantity
     * @param float $percentage
     * @param string $applicability
     * @param int $maxQuantity
     */
    public function __construct($unitCharge = null, $unitName = null, $quantity = null, $percentage = null, $applicability = null, $maxQuantity = null)
    {
        $this
            ->setUnitCharge($unitCharge)
            ->setUnitName($unitName)
            ->setQuantity($quantity)
            ->setPercentage($percentage)
            ->setApplicability($applicability)
            ->setMaxQuantity($maxQuantity);
    }
    /**
     * Get UnitCharge value
     * @return float|null
     */
    public function getUnitCharge()
    {
        return $this->UnitCharge;
    }
    /**
     * Set UnitCharge value
     * @param float $unitCharge
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation
     */
    public function setUnitCharge($unitCharge = null)
    {
        $this->UnitCharge = $unitCharge;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get Applicability value
     * @return string|null
     */
    public function getApplicability()
    {
        return $this->Applicability;
    }
    /**
     * Set Applicability value
     * @uses \dgsoft\EnumType\DgVehicleChargeTypeCalculationApplicability::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleChargeTypeCalculationApplicability::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicability
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation
     */
    public function setApplicability($applicability = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleChargeTypeCalculationApplicability::valueIsValid($applicability)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $applicability, implode(', ', \dgsoft\EnumType\DgVehicleChargeTypeCalculationApplicability::getValidValues())), __LINE__);
        }
        $this->Applicability = $applicability;
        return $this;
    }
    /**
     * Get MaxQuantity value
     * @return int|null
     */
    public function getMaxQuantity()
    {
        return $this->MaxQuantity;
    }
    /**
     * Set MaxQuantity value
     * @param int $maxQuantity
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation
     */
    public function setMaxQuantity($maxQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuantity) && !is_numeric($maxQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxQuantity)), __LINE__);
        }
        $this->MaxQuantity = $maxQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
