<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailRQCoreTypeRateRange StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailRQCoreTypeRateRange extends AbstractStructBase
{
    /**
     * The MinRate
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * @var float
     */
    public $MaxRate;
    /**
     * The FixedRate
     * @var float
     */
    public $FixedRate;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * Constructor method for VehicleAvailRQCoreTypeRateRange
     * @uses DgVehicleAvailRQCoreTypeRateRange::setMinRate()
     * @uses DgVehicleAvailRQCoreTypeRateRange::setMaxRate()
     * @uses DgVehicleAvailRQCoreTypeRateRange::setFixedRate()
     * @uses DgVehicleAvailRQCoreTypeRateRange::setRateTimeUnit()
     * @param float $minRate
     * @param float $maxRate
     * @param float $fixedRate
     * @param string $rateTimeUnit
     */
    public function __construct($minRate = null, $maxRate = null, $fixedRate = null, $rateTimeUnit = null)
    {
        $this
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setFixedRate($fixedRate)
            ->setRateTimeUnit($rateTimeUnit);
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange
     */
    public function setMinRate($minRate = null)
    {
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange
     */
    public function setMaxRate($maxRate = null)
    {
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get FixedRate value
     * @return float|null
     */
    public function getFixedRate()
    {
        return $this->FixedRate;
    }
    /**
     * Set FixedRate value
     * @param float $fixedRate
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange
     */
    public function setFixedRate($fixedRate = null)
    {
        $this->FixedRate = $fixedRate;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rateTimeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
