<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailRQCoreTypeRateQualifier StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailRQCoreTypeRateQualifier extends AbstractStructBase
{
    /**
     * The TravelPurpose
     * @var string
     */
    public $TravelPurpose;
    /**
     * The RateCategory
     * @var string
     */
    public $RateCategory;
    /**
     * The CorpDiscountNmbr
     * @var string
     */
    public $CorpDiscountNmbr;
    /**
     * The RateQualifier
     * @var string
     */
    public $RateQualifier;
    /**
     * The RatePeriod
     * @var string
     */
    public $RatePeriod;
    /**
     * The GuaranteedInd
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * Constructor method for VehicleAvailRQCoreTypeRateQualifier
     * @uses DgVehicleAvailRQCoreTypeRateQualifier::setTravelPurpose()
     * @uses DgVehicleAvailRQCoreTypeRateQualifier::setRateCategory()
     * @uses DgVehicleAvailRQCoreTypeRateQualifier::setCorpDiscountNmbr()
     * @uses DgVehicleAvailRQCoreTypeRateQualifier::setRateQualifier()
     * @uses DgVehicleAvailRQCoreTypeRateQualifier::setRatePeriod()
     * @uses DgVehicleAvailRQCoreTypeRateQualifier::setGuaranteedInd()
     * @param string $travelPurpose
     * @param string $rateCategory
     * @param string $corpDiscountNmbr
     * @param string $rateQualifier
     * @param string $ratePeriod
     * @param bool $guaranteedInd
     */
    public function __construct($travelPurpose = null, $rateCategory = null, $corpDiscountNmbr = null, $rateQualifier = null, $ratePeriod = null, $guaranteedInd = null)
    {
        $this
            ->setTravelPurpose($travelPurpose)
            ->setRateCategory($rateCategory)
            ->setCorpDiscountNmbr($corpDiscountNmbr)
            ->setRateQualifier($rateQualifier)
            ->setRatePeriod($ratePeriod)
            ->setGuaranteedInd($guaranteedInd);
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Get RateCategory value
     * @return string|null
     */
    public function getRateCategory()
    {
        return $this->RateCategory;
    }
    /**
     * Set RateCategory value
     * @param string $rateCategory
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier
     */
    public function setRateCategory($rateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategory) && !is_string($rateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateCategory)), __LINE__);
        }
        $this->RateCategory = $rateCategory;
        return $this;
    }
    /**
     * Get CorpDiscountNmbr value
     * @return string|null
     */
    public function getCorpDiscountNmbr()
    {
        return $this->CorpDiscountNmbr;
    }
    /**
     * Set CorpDiscountNmbr value
     * @param string $corpDiscountNmbr
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier
     */
    public function setCorpDiscountNmbr($corpDiscountNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountNmbr) && !is_string($corpDiscountNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corpDiscountNmbr)), __LINE__);
        }
        $this->CorpDiscountNmbr = $corpDiscountNmbr;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return string|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param string $rateQualifier
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier
     */
    public function setRateQualifier($rateQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($rateQualifier) && !is_string($rateQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateQualifier)), __LINE__);
        }
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get RatePeriod value
     * @return string|null
     */
    public function getRatePeriod()
    {
        return $this->RatePeriod;
    }
    /**
     * Set RatePeriod value
     * @uses \dgsoft\EnumType\DgVehicleAvailRQCoreTypeRateQualifierRatePeriod::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleAvailRQCoreTypeRateQualifierRatePeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ratePeriod
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier
     */
    public function setRatePeriod($ratePeriod = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleAvailRQCoreTypeRateQualifierRatePeriod::valueIsValid($ratePeriod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ratePeriod, implode(', ', \dgsoft\EnumType\DgVehicleAvailRQCoreTypeRateQualifierRatePeriod::getValidValues())), __LINE__);
        }
        $this->RatePeriod = $ratePeriod;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
