<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailRQCoreType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailRQCoreType extends AbstractStructBase
{
    /**
     * The Unlimited
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Unlimited;
    /**
     * The VehRentalCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public $VehRentalCore;
    /**
     * The VendorPrefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs
     */
    public $VendorPrefs;
    /**
     * The VehPrefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeVehPref
     */
    public $VehPrefs;
    /**
     * The DriverType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType[]
     */
    public $DriverType;
    /**
     * The RateQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier[]
     */
    public $RateQualifier;
    /**
     * The RateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange
     */
    public $RateRange;
    /**
     * The SpecialEquipPrefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeSpecialEquipPref
     */
    public $SpecialEquipPrefs;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The TargetSource
     * @var string
     */
    public $TargetSource;
    /**
     * Constructor method for VehicleAvailRQCoreType
     * @uses DgVehicleAvailRQCoreType::setUnlimited()
     * @uses DgVehicleAvailRQCoreType::setVehRentalCore()
     * @uses DgVehicleAvailRQCoreType::setVendorPrefs()
     * @uses DgVehicleAvailRQCoreType::setVehPrefs()
     * @uses DgVehicleAvailRQCoreType::setDriverType()
     * @uses DgVehicleAvailRQCoreType::setRateQualifier()
     * @uses DgVehicleAvailRQCoreType::setRateRange()
     * @uses DgVehicleAvailRQCoreType::setSpecialEquipPrefs()
     * @uses DgVehicleAvailRQCoreType::setTPA_Extensions()
     * @uses DgVehicleAvailRQCoreType::setStatus()
     * @uses DgVehicleAvailRQCoreType::setTargetSource()
     * @param bool $unlimited
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs $vendorPrefs
     * @param \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeVehPref $vehPrefs
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType[] $driverType
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier[] $rateQualifier
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange $rateRange
     * @param \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeSpecialEquipPref $specialEquipPrefs
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $status
     * @param string $targetSource
     */
    public function __construct($unlimited = null, \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null, \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs $vendorPrefs = null, \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeVehPref $vehPrefs = null, array $driverType = array(), array $rateQualifier = array(), \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange $rateRange = null, \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeSpecialEquipPref $specialEquipPrefs = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $status = null, $targetSource = null)
    {
        $this
            ->setUnlimited($unlimited)
            ->setVehRentalCore($vehRentalCore)
            ->setVendorPrefs($vendorPrefs)
            ->setVehPrefs($vehPrefs)
            ->setDriverType($driverType)
            ->setRateQualifier($rateQualifier)
            ->setRateRange($rateRange)
            ->setSpecialEquipPrefs($specialEquipPrefs)
            ->setTPA_Extensions($tPA_Extensions)
            ->setStatus($status)
            ->setTargetSource($targetSource);
    }
    /**
     * Get Unlimited value
     * @return bool
     */
    public function getUnlimited()
    {
        return $this->Unlimited;
    }
    /**
     * Set Unlimited value
     * @param bool $unlimited
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setUnlimited($unlimited = null)
    {
        // validation for constraint: boolean
        if (!is_null($unlimited) && !is_bool($unlimited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unlimited)), __LINE__);
        }
        $this->Unlimited = $unlimited;
        return $this;
    }
    /**
     * Get VehRentalCore value
     * @return \dgsoft\StructType\DgVehicleRentalCoreType|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setVehRentalCore(\dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get VendorPrefs value
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs|null
     */
    public function getVendorPrefs()
    {
        return $this->VendorPrefs;
    }
    /**
     * Set VendorPrefs value
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs $vendorPrefs
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setVendorPrefs(\dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs $vendorPrefs = null)
    {
        $this->VendorPrefs = $vendorPrefs;
        return $this;
    }
    /**
     * Get VehPrefs value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeVehPref|null
     */
    public function getVehPrefs()
    {
        return $this->VehPrefs;
    }
    /**
     * Set VehPrefs value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeVehPref $vehPrefs
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setVehPrefs(\dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeVehPref $vehPrefs = null)
    {
        $this->VehPrefs = $vehPrefs;
        return $this;
    }
    /**
     * Get DriverType value
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType[]|null
     */
    public function getDriverType()
    {
        return $this->DriverType;
    }
    /**
     * Set DriverType value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType[] $driverType
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setDriverType(array $driverType = array())
    {
        foreach ($driverType as $vehicleAvailRQCoreTypeDriverTypeItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQCoreTypeDriverTypeItem instanceof \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType) {
                throw new \InvalidArgumentException(sprintf('The DriverType property can only contain items of \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType, "%s" given', is_object($vehicleAvailRQCoreTypeDriverTypeItem) ? get_class($vehicleAvailRQCoreTypeDriverTypeItem) : gettype($vehicleAvailRQCoreTypeDriverTypeItem)), __LINE__);
            }
        }
        $this->DriverType = $driverType;
        return $this;
    }
    /**
     * Add item to DriverType value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType $item
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function addToDriverType(\dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType) {
            throw new \InvalidArgumentException(sprintf('The DriverType property can only contain items of \dgsoft\StructType\DgVehicleAvailRQCoreTypeDriverType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DriverType[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier[]|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier[] $rateQualifier
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setRateQualifier(array $rateQualifier = array())
    {
        foreach ($rateQualifier as $vehicleAvailRQCoreTypeRateQualifierItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQCoreTypeRateQualifierItem instanceof \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier) {
                throw new \InvalidArgumentException(sprintf('The RateQualifier property can only contain items of \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier, "%s" given', is_object($vehicleAvailRQCoreTypeRateQualifierItem) ? get_class($vehicleAvailRQCoreTypeRateQualifierItem) : gettype($vehicleAvailRQCoreTypeRateQualifierItem)), __LINE__);
            }
        }
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Add item to RateQualifier value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier $item
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function addToRateQualifier(\dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier) {
            throw new \InvalidArgumentException(sprintf('The RateQualifier property can only contain items of \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateQualifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RateQualifier[] = $item;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange $rateRange
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setRateRange(\dgsoft\StructType\DgVehicleAvailRQCoreTypeRateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get SpecialEquipPrefs value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeSpecialEquipPref|null
     */
    public function getSpecialEquipPrefs()
    {
        return $this->SpecialEquipPrefs;
    }
    /**
     * Set SpecialEquipPrefs value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeSpecialEquipPref $specialEquipPrefs
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setSpecialEquipPrefs(\dgsoft\ArrayType\DgArrayOfVehicleAvailRQCoreTypeSpecialEquipPref $specialEquipPrefs = null)
    {
        $this->SpecialEquipPrefs = $specialEquipPrefs;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \dgsoft\EnumType\DgInventoryStatusType::valueIsValid()
     * @uses \dgsoft\EnumType\DgInventoryStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgInventoryStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \dgsoft\EnumType\DgInventoryStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TargetSource value
     * @return string|null
     */
    public function getTargetSource()
    {
        return $this->TargetSource;
    }
    /**
     * Set TargetSource value
     * @param string $targetSource
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public function setTargetSource($targetSource = null)
    {
        // validation for constraint: string
        if (!is_null($targetSource) && !is_string($targetSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetSource)), __LINE__);
        }
        $this->TargetSource = $targetSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
