<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailCoreTypeVendorLocation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailCoreTypeVendorLocation extends DgLocationType
{
    /**
     * The _
     * @var \dgsoft\StructType\DgLocationType
     */
    public $_;
    /**
     * The ExtendedLocationCode
     * @var string
     */
    public $ExtendedLocationCode;
    /**
     * The CounterLocation
     * @var string
     */
    public $CounterLocation;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The CounterLocInfo
     * @var string
     */
    public $CounterLocInfo;
    /**
     * Constructor method for VehicleAvailCoreTypeVendorLocation
     * @uses DgVehicleAvailCoreTypeVendorLocation::set_()
     * @uses DgVehicleAvailCoreTypeVendorLocation::setExtendedLocationCode()
     * @uses DgVehicleAvailCoreTypeVendorLocation::setCounterLocation()
     * @uses DgVehicleAvailCoreTypeVendorLocation::setName()
     * @uses DgVehicleAvailCoreTypeVendorLocation::setCounterLocInfo()
     * @param \dgsoft\StructType\DgLocationType $_
     * @param string $extendedLocationCode
     * @param string $counterLocation
     * @param string $name
     * @param string $counterLocInfo
     */
    public function __construct(\dgsoft\StructType\DgLocationType $_ = null, $extendedLocationCode = null, $counterLocation = null, $name = null, $counterLocInfo = null)
    {
        $this
            ->set_($_)
            ->setExtendedLocationCode($extendedLocationCode)
            ->setCounterLocation($counterLocation)
            ->setName($name)
            ->setCounterLocInfo($counterLocInfo);
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgLocationType $_
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation
     */
    public function set_(\dgsoft\StructType\DgLocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ExtendedLocationCode value
     * @return string|null
     */
    public function getExtendedLocationCode()
    {
        return $this->ExtendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation
     */
    public function setExtendedLocationCode($extendedLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($extendedLocationCode) && !is_string($extendedLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extendedLocationCode)), __LINE__);
        }
        $this->ExtendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Get CounterLocation value
     * @return string|null
     */
    public function getCounterLocation()
    {
        return $this->CounterLocation;
    }
    /**
     * Set CounterLocation value
     * @param string $counterLocation
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation
     */
    public function setCounterLocation($counterLocation = null)
    {
        // validation for constraint: string
        if (!is_null($counterLocation) && !is_string($counterLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($counterLocation)), __LINE__);
        }
        $this->CounterLocation = $counterLocation;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CounterLocInfo value
     * @return string|null
     */
    public function getCounterLocInfo()
    {
        return $this->CounterLocInfo;
    }
    /**
     * Set CounterLocInfo value
     * @uses \dgsoft\EnumType\DgVehicleAvailCoreTypeVendorLocationCounterLocInfo::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleAvailCoreTypeVendorLocationCounterLocInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $counterLocInfo
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation
     */
    public function setCounterLocInfo($counterLocInfo = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleAvailCoreTypeVendorLocationCounterLocInfo::valueIsValid($counterLocInfo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $counterLocInfo, implode(', ', \dgsoft\EnumType\DgVehicleAvailCoreTypeVendorLocationCounterLocInfo::getValidValues())), __LINE__);
        }
        $this->CounterLocInfo = $counterLocInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
