<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleArrivalDetailsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleArrivalDetailsType extends AbstractStructBase
{
    /**
     * The ArrivalLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $ArrivalLocation;
    /**
     * The MarketingCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $MarketingCompany;
    /**
     * The OperatingCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $OperatingCompany;
    /**
     * The TransportationCode
     * @var string
     */
    public $TransportationCode;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The ArrivalDateTime
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * Constructor method for VehicleArrivalDetailsType
     * @uses DgVehicleArrivalDetailsType::setArrivalLocation()
     * @uses DgVehicleArrivalDetailsType::setMarketingCompany()
     * @uses DgVehicleArrivalDetailsType::setOperatingCompany()
     * @uses DgVehicleArrivalDetailsType::setTransportationCode()
     * @uses DgVehicleArrivalDetailsType::setNumber()
     * @uses DgVehicleArrivalDetailsType::setArrivalDateTime()
     * @param \dgsoft\StructType\DgLocationType $arrivalLocation
     * @param \dgsoft\StructType\DgCompanyNameType $marketingCompany
     * @param \dgsoft\StructType\DgCompanyNameType $operatingCompany
     * @param string $transportationCode
     * @param string $number
     * @param string $arrivalDateTime
     */
    public function __construct(\dgsoft\StructType\DgLocationType $arrivalLocation = null, \dgsoft\StructType\DgCompanyNameType $marketingCompany = null, \dgsoft\StructType\DgCompanyNameType $operatingCompany = null, $transportationCode = null, $number = null, $arrivalDateTime = null)
    {
        $this
            ->setArrivalLocation($arrivalLocation)
            ->setMarketingCompany($marketingCompany)
            ->setOperatingCompany($operatingCompany)
            ->setTransportationCode($transportationCode)
            ->setNumber($number)
            ->setArrivalDateTime($arrivalDateTime);
    }
    /**
     * Get ArrivalLocation value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @param \dgsoft\StructType\DgLocationType $arrivalLocation
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public function setArrivalLocation(\dgsoft\StructType\DgLocationType $arrivalLocation = null)
    {
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Get MarketingCompany value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getMarketingCompany()
    {
        return $this->MarketingCompany;
    }
    /**
     * Set MarketingCompany value
     * @param \dgsoft\StructType\DgCompanyNameType $marketingCompany
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public function setMarketingCompany(\dgsoft\StructType\DgCompanyNameType $marketingCompany = null)
    {
        $this->MarketingCompany = $marketingCompany;
        return $this;
    }
    /**
     * Get OperatingCompany value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getOperatingCompany()
    {
        return $this->OperatingCompany;
    }
    /**
     * Set OperatingCompany value
     * @param \dgsoft\StructType\DgCompanyNameType $operatingCompany
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public function setOperatingCompany(\dgsoft\StructType\DgCompanyNameType $operatingCompany = null)
    {
        $this->OperatingCompany = $operatingCompany;
        return $this;
    }
    /**
     * Get TransportationCode value
     * @return string|null
     */
    public function getTransportationCode()
    {
        return $this->TransportationCode;
    }
    /**
     * Set TransportationCode value
     * @param string $transportationCode
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public function setTransportationCode($transportationCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportationCode) && !is_string($transportationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportationCode)), __LINE__);
        }
        $this->TransportationCode = $transportationCode;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
