<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserOperationsRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgUserOperationsRQ extends AbstractStructBase
{
    /**
     * The CultureCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureCode;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUser
     */
    public $User;
    /**
     * Constructor method for UserOperationsRQ
     * @uses DgUserOperationsRQ::setCultureCode()
     * @uses DgUserOperationsRQ::setUser()
     * @param string $cultureCode
     * @param \dgsoft\StructType\DgUser $user
     */
    public function __construct($cultureCode = null, \dgsoft\StructType\DgUser $user = null)
    {
        $this
            ->setCultureCode($cultureCode)
            ->setUser($user);
    }
    /**
     * Get CultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->CultureCode;
    }
    /**
     * Set CultureCode value
     * @param string $cultureCode
     * @return \dgsoft\StructType\DgUserOperationsRQ
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cultureCode)), __LINE__);
        }
        $this->CultureCode = $cultureCode;
        return $this;
    }
    /**
     * Get User value
     * @return \dgsoft\StructType\DgUser|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \dgsoft\StructType\DgUser $user
     * @return \dgsoft\StructType\DgUserOperationsRQ
     */
    public function setUser(\dgsoft\StructType\DgUser $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgUserOperationsRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
