<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserID StructType
 * @package Dg
 * @subpackage Structs
 */
class DgUserID extends DgUniqueID_Type
{
    /**
     * The PinNumber
     * @var string
     */
    public $PinNumber;
    /**
     * Constructor method for UserID
     * @uses DgUserID::setPinNumber()
     * @param string $pinNumber
     */
    public function __construct($pinNumber = null)
    {
        $this
            ->setPinNumber($pinNumber);
    }
    /**
     * Get PinNumber value
     * @return string|null
     */
    public function getPinNumber()
    {
        return $this->PinNumber;
    }
    /**
     * Set PinNumber value
     * @param string $pinNumber
     * @return \dgsoft\StructType\DgUserID
     */
    public function setPinNumber($pinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pinNumber) && !is_string($pinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pinNumber)), __LINE__);
        }
        $this->PinNumber = $pinNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgUserID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
