<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for User StructType
 * @package Dg
 * @subpackage Structs
 */
class DgUser extends DgPassengerDB
{
    /**
     * The IsEticketAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsEticketAllowed;
    /**
     * The IsEticketRequestAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsEticketRequestAllowed;
    /**
     * The CorporateUserGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $CorporateUserGroupID;
    /**
     * The MemberDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MemberDate;
    /**
     * The IsApprovedMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsApprovedMember;
    /**
     * The PortalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $PortalID;
    /**
     * The IsCallMeAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsCallMeAllowed;
    /**
     * The IsCreditCardAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsCreditCardAllowed;
    /**
     * The CurrentAccountAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CurrentAccountAmount;
    /**
     * The ACurrentAccountAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ACurrentAccountAmount;
    /**
     * The CorporateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $CorporateID;
    /**
     * The VirtualCorporateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $VirtualCorporateID;
    /**
     * The Registration1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Registration1;
    /**
     * The Registration2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Registration2;
    /**
     * The IsTravelApprover
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsTravelApprover;
    /**
     * The IsTravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsTravelArranger;
    /**
     * The ApproverNotRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ApproverNotRequired;
    /**
     * The ModifyProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ModifyProfile;
    /**
     * The IsLocked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsLocked;
    /**
     * The AllowToAccessCorpReports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AllowToAccessCorpReports;
    /**
     * The PRDADMIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PRDADMIN;
    /**
     * The UICustRights
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UICustRights;
    /**
     * The UIMigrationUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UIMigrationUser;
    /**
     * The LogID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $LogID;
    /**
     * The ExtraProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfNameValueTypeItem
     */
    public $ExtraProperties;
    /**
     * The ExtraSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfNameValueTypeItem
     */
    public $ExtraSettings;
    /**
     * The GuestUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuestUserId;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The HashedPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HashedPassword;
    /**
     * The Salt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Salt;
    /**
     * The PasswordAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PasswordAnswer;
    /**
     * The HashedPasswordAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HashedPasswordAnswer;
    /**
     * The PasswordQuestion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PasswordQuestion;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPassengerDB
     */
    public $Passengers;
    /**
     * The UserCulture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserCulture;
    /**
     * The AccountAmountCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountAmountCurrency;
    /**
     * The Tolerance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tolerance;
    /**
     * The ContactPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPerson
     */
    public $ContactPerson;
    /**
     * The UserCorporate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCorporate
     */
    public $UserCorporate;
    /**
     * The TravelApprovers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfUser
     */
    public $TravelApprovers;
    /**
     * The TravelArrangers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfUser
     */
    public $TravelArrangers;
    /**
     * The BookingAllow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingAllow;
    /**
     * The OPSProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOPSProfile
     */
    public $OPSProfile;
    /**
     * Constructor method for User
     * @uses DgUser::setIsEticketAllowed()
     * @uses DgUser::setIsEticketRequestAllowed()
     * @uses DgUser::setCorporateUserGroupID()
     * @uses DgUser::setMemberDate()
     * @uses DgUser::setIsApprovedMember()
     * @uses DgUser::setPortalID()
     * @uses DgUser::setIsCallMeAllowed()
     * @uses DgUser::setIsCreditCardAllowed()
     * @uses DgUser::setCurrentAccountAmount()
     * @uses DgUser::setACurrentAccountAmount()
     * @uses DgUser::setCorporateID()
     * @uses DgUser::setVirtualCorporateID()
     * @uses DgUser::setRegistration1()
     * @uses DgUser::setRegistration2()
     * @uses DgUser::setIsTravelApprover()
     * @uses DgUser::setIsTravelArranger()
     * @uses DgUser::setApproverNotRequired()
     * @uses DgUser::setModifyProfile()
     * @uses DgUser::setIsLocked()
     * @uses DgUser::setAllowToAccessCorpReports()
     * @uses DgUser::setPRDADMIN()
     * @uses DgUser::setUICustRights()
     * @uses DgUser::setUIMigrationUser()
     * @uses DgUser::setLogID()
     * @uses DgUser::setExtraProperties()
     * @uses DgUser::setExtraSettings()
     * @uses DgUser::setGuestUserId()
     * @uses DgUser::setUserName()
     * @uses DgUser::setPassword()
     * @uses DgUser::setHashedPassword()
     * @uses DgUser::setSalt()
     * @uses DgUser::setPasswordAnswer()
     * @uses DgUser::setHashedPasswordAnswer()
     * @uses DgUser::setPasswordQuestion()
     * @uses DgUser::setEmail()
     * @uses DgUser::setPassengers()
     * @uses DgUser::setUserCulture()
     * @uses DgUser::setAccountAmountCurrency()
     * @uses DgUser::setTolerance()
     * @uses DgUser::setContactPerson()
     * @uses DgUser::setUserCorporate()
     * @uses DgUser::setTravelApprovers()
     * @uses DgUser::setTravelArrangers()
     * @uses DgUser::setBookingAllow()
     * @uses DgUser::setOPSProfile()
     * @param bool $isEticketAllowed
     * @param bool $isEticketRequestAllowed
     * @param string $corporateUserGroupID
     * @param string $memberDate
     * @param bool $isApprovedMember
     * @param string $portalID
     * @param bool $isCallMeAllowed
     * @param bool $isCreditCardAllowed
     * @param float $currentAccountAmount
     * @param float $aCurrentAccountAmount
     * @param string $corporateID
     * @param string $virtualCorporateID
     * @param bool $registration1
     * @param bool $registration2
     * @param bool $isTravelApprover
     * @param bool $isTravelArranger
     * @param bool $approverNotRequired
     * @param bool $modifyProfile
     * @param bool $isLocked
     * @param bool $allowToAccessCorpReports
     * @param bool $pRDADMIN
     * @param string $uICustRights
     * @param bool $uIMigrationUser
     * @param string $logID
     * @param \dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraProperties
     * @param \dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraSettings
     * @param string $guestUserId
     * @param string $userName
     * @param string $password
     * @param string $hashedPassword
     * @param string $salt
     * @param string $passwordAnswer
     * @param string $hashedPasswordAnswer
     * @param string $passwordQuestion
     * @param string $email
     * @param \dgsoft\ArrayType\DgArrayOfPassengerDB $passengers
     * @param string $userCulture
     * @param string $accountAmountCurrency
     * @param string $tolerance
     * @param \dgsoft\StructType\DgPerson $contactPerson
     * @param \dgsoft\StructType\DgCorporate $userCorporate
     * @param \dgsoft\ArrayType\DgArrayOfUser $travelApprovers
     * @param \dgsoft\ArrayType\DgArrayOfUser $travelArrangers
     * @param string $bookingAllow
     * @param \dgsoft\StructType\DgOPSProfile $oPSProfile
     */
    public function __construct($isEticketAllowed = null, $isEticketRequestAllowed = null, $corporateUserGroupID = null, $memberDate = null, $isApprovedMember = null, $portalID = null, $isCallMeAllowed = null, $isCreditCardAllowed = null, $currentAccountAmount = null, $aCurrentAccountAmount = null, $corporateID = null, $virtualCorporateID = null, $registration1 = null, $registration2 = null, $isTravelApprover = null, $isTravelArranger = null, $approverNotRequired = null, $modifyProfile = null, $isLocked = null, $allowToAccessCorpReports = null, $pRDADMIN = null, $uICustRights = null, $uIMigrationUser = null, $logID = null, \dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraProperties = null, \dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraSettings = null, $guestUserId = null, $userName = null, $password = null, $hashedPassword = null, $salt = null, $passwordAnswer = null, $hashedPasswordAnswer = null, $passwordQuestion = null, $email = null, \dgsoft\ArrayType\DgArrayOfPassengerDB $passengers = null, $userCulture = null, $accountAmountCurrency = null, $tolerance = null, \dgsoft\StructType\DgPerson $contactPerson = null, \dgsoft\StructType\DgCorporate $userCorporate = null, \dgsoft\ArrayType\DgArrayOfUser $travelApprovers = null, \dgsoft\ArrayType\DgArrayOfUser $travelArrangers = null, $bookingAllow = null, \dgsoft\StructType\DgOPSProfile $oPSProfile = null)
    {
        $this
            ->setIsEticketAllowed($isEticketAllowed)
            ->setIsEticketRequestAllowed($isEticketRequestAllowed)
            ->setCorporateUserGroupID($corporateUserGroupID)
            ->setMemberDate($memberDate)
            ->setIsApprovedMember($isApprovedMember)
            ->setPortalID($portalID)
            ->setIsCallMeAllowed($isCallMeAllowed)
            ->setIsCreditCardAllowed($isCreditCardAllowed)
            ->setCurrentAccountAmount($currentAccountAmount)
            ->setACurrentAccountAmount($aCurrentAccountAmount)
            ->setCorporateID($corporateID)
            ->setVirtualCorporateID($virtualCorporateID)
            ->setRegistration1($registration1)
            ->setRegistration2($registration2)
            ->setIsTravelApprover($isTravelApprover)
            ->setIsTravelArranger($isTravelArranger)
            ->setApproverNotRequired($approverNotRequired)
            ->setModifyProfile($modifyProfile)
            ->setIsLocked($isLocked)
            ->setAllowToAccessCorpReports($allowToAccessCorpReports)
            ->setPRDADMIN($pRDADMIN)
            ->setUICustRights($uICustRights)
            ->setUIMigrationUser($uIMigrationUser)
            ->setLogID($logID)
            ->setExtraProperties($extraProperties)
            ->setExtraSettings($extraSettings)
            ->setGuestUserId($guestUserId)
            ->setUserName($userName)
            ->setPassword($password)
            ->setHashedPassword($hashedPassword)
            ->setSalt($salt)
            ->setPasswordAnswer($passwordAnswer)
            ->setHashedPasswordAnswer($hashedPasswordAnswer)
            ->setPasswordQuestion($passwordQuestion)
            ->setEmail($email)
            ->setPassengers($passengers)
            ->setUserCulture($userCulture)
            ->setAccountAmountCurrency($accountAmountCurrency)
            ->setTolerance($tolerance)
            ->setContactPerson($contactPerson)
            ->setUserCorporate($userCorporate)
            ->setTravelApprovers($travelApprovers)
            ->setTravelArrangers($travelArrangers)
            ->setBookingAllow($bookingAllow)
            ->setOPSProfile($oPSProfile);
    }
    /**
     * Get IsEticketAllowed value
     * @return bool
     */
    public function getIsEticketAllowed()
    {
        return $this->IsEticketAllowed;
    }
    /**
     * Set IsEticketAllowed value
     * @param bool $isEticketAllowed
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsEticketAllowed($isEticketAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEticketAllowed) && !is_bool($isEticketAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEticketAllowed)), __LINE__);
        }
        $this->IsEticketAllowed = $isEticketAllowed;
        return $this;
    }
    /**
     * Get IsEticketRequestAllowed value
     * @return bool
     */
    public function getIsEticketRequestAllowed()
    {
        return $this->IsEticketRequestAllowed;
    }
    /**
     * Set IsEticketRequestAllowed value
     * @param bool $isEticketRequestAllowed
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsEticketRequestAllowed($isEticketRequestAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEticketRequestAllowed) && !is_bool($isEticketRequestAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEticketRequestAllowed)), __LINE__);
        }
        $this->IsEticketRequestAllowed = $isEticketRequestAllowed;
        return $this;
    }
    /**
     * Get CorporateUserGroupID value
     * @return string
     */
    public function getCorporateUserGroupID()
    {
        return $this->CorporateUserGroupID;
    }
    /**
     * Set CorporateUserGroupID value
     * @param string $corporateUserGroupID
     * @return \dgsoft\StructType\DgUser
     */
    public function setCorporateUserGroupID($corporateUserGroupID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($corporateUserGroupID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $corporateUserGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($corporateUserGroupID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($corporateUserGroupID) && !is_string($corporateUserGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corporateUserGroupID)), __LINE__);
        }
        $this->CorporateUserGroupID = $corporateUserGroupID;
        return $this;
    }
    /**
     * Get MemberDate value
     * @return string
     */
    public function getMemberDate()
    {
        return $this->MemberDate;
    }
    /**
     * Set MemberDate value
     * @param string $memberDate
     * @return \dgsoft\StructType\DgUser
     */
    public function setMemberDate($memberDate = null)
    {
        // validation for constraint: string
        if (!is_null($memberDate) && !is_string($memberDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memberDate)), __LINE__);
        }
        $this->MemberDate = $memberDate;
        return $this;
    }
    /**
     * Get IsApprovedMember value
     * @return bool
     */
    public function getIsApprovedMember()
    {
        return $this->IsApprovedMember;
    }
    /**
     * Set IsApprovedMember value
     * @param bool $isApprovedMember
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsApprovedMember($isApprovedMember = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApprovedMember) && !is_bool($isApprovedMember)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApprovedMember)), __LINE__);
        }
        $this->IsApprovedMember = $isApprovedMember;
        return $this;
    }
    /**
     * Get PortalID value
     * @return string
     */
    public function getPortalID()
    {
        return $this->PortalID;
    }
    /**
     * Set PortalID value
     * @param string $portalID
     * @return \dgsoft\StructType\DgUser
     */
    public function setPortalID($portalID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($portalID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $portalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($portalID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($portalID) && !is_string($portalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portalID)), __LINE__);
        }
        $this->PortalID = $portalID;
        return $this;
    }
    /**
     * Get IsCallMeAllowed value
     * @return bool
     */
    public function getIsCallMeAllowed()
    {
        return $this->IsCallMeAllowed;
    }
    /**
     * Set IsCallMeAllowed value
     * @param bool $isCallMeAllowed
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsCallMeAllowed($isCallMeAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCallMeAllowed) && !is_bool($isCallMeAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCallMeAllowed)), __LINE__);
        }
        $this->IsCallMeAllowed = $isCallMeAllowed;
        return $this;
    }
    /**
     * Get IsCreditCardAllowed value
     * @return bool
     */
    public function getIsCreditCardAllowed()
    {
        return $this->IsCreditCardAllowed;
    }
    /**
     * Set IsCreditCardAllowed value
     * @param bool $isCreditCardAllowed
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsCreditCardAllowed($isCreditCardAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreditCardAllowed) && !is_bool($isCreditCardAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCreditCardAllowed)), __LINE__);
        }
        $this->IsCreditCardAllowed = $isCreditCardAllowed;
        return $this;
    }
    /**
     * Get CurrentAccountAmount value
     * @return float
     */
    public function getCurrentAccountAmount()
    {
        return $this->CurrentAccountAmount;
    }
    /**
     * Set CurrentAccountAmount value
     * @param float $currentAccountAmount
     * @return \dgsoft\StructType\DgUser
     */
    public function setCurrentAccountAmount($currentAccountAmount = null)
    {
        $this->CurrentAccountAmount = $currentAccountAmount;
        return $this;
    }
    /**
     * Get ACurrentAccountAmount value
     * @return float
     */
    public function getACurrentAccountAmount()
    {
        return $this->ACurrentAccountAmount;
    }
    /**
     * Set ACurrentAccountAmount value
     * @param float $aCurrentAccountAmount
     * @return \dgsoft\StructType\DgUser
     */
    public function setACurrentAccountAmount($aCurrentAccountAmount = null)
    {
        $this->ACurrentAccountAmount = $aCurrentAccountAmount;
        return $this;
    }
    /**
     * Get CorporateID value
     * @return string
     */
    public function getCorporateID()
    {
        return $this->CorporateID;
    }
    /**
     * Set CorporateID value
     * @param string $corporateID
     * @return \dgsoft\StructType\DgUser
     */
    public function setCorporateID($corporateID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($corporateID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $corporateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($corporateID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($corporateID) && !is_string($corporateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corporateID)), __LINE__);
        }
        $this->CorporateID = $corporateID;
        return $this;
    }
    /**
     * Get VirtualCorporateID value
     * @return string
     */
    public function getVirtualCorporateID()
    {
        return $this->VirtualCorporateID;
    }
    /**
     * Set VirtualCorporateID value
     * @param string $virtualCorporateID
     * @return \dgsoft\StructType\DgUser
     */
    public function setVirtualCorporateID($virtualCorporateID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($virtualCorporateID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $virtualCorporateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($virtualCorporateID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($virtualCorporateID) && !is_string($virtualCorporateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($virtualCorporateID)), __LINE__);
        }
        $this->VirtualCorporateID = $virtualCorporateID;
        return $this;
    }
    /**
     * Get Registration1 value
     * @return bool
     */
    public function getRegistration1()
    {
        return $this->Registration1;
    }
    /**
     * Set Registration1 value
     * @param bool $registration1
     * @return \dgsoft\StructType\DgUser
     */
    public function setRegistration1($registration1 = null)
    {
        // validation for constraint: boolean
        if (!is_null($registration1) && !is_bool($registration1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($registration1)), __LINE__);
        }
        $this->Registration1 = $registration1;
        return $this;
    }
    /**
     * Get Registration2 value
     * @return bool
     */
    public function getRegistration2()
    {
        return $this->Registration2;
    }
    /**
     * Set Registration2 value
     * @param bool $registration2
     * @return \dgsoft\StructType\DgUser
     */
    public function setRegistration2($registration2 = null)
    {
        // validation for constraint: boolean
        if (!is_null($registration2) && !is_bool($registration2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($registration2)), __LINE__);
        }
        $this->Registration2 = $registration2;
        return $this;
    }
    /**
     * Get IsTravelApprover value
     * @return bool
     */
    public function getIsTravelApprover()
    {
        return $this->IsTravelApprover;
    }
    /**
     * Set IsTravelApprover value
     * @param bool $isTravelApprover
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsTravelApprover($isTravelApprover = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTravelApprover) && !is_bool($isTravelApprover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTravelApprover)), __LINE__);
        }
        $this->IsTravelApprover = $isTravelApprover;
        return $this;
    }
    /**
     * Get IsTravelArranger value
     * @return bool
     */
    public function getIsTravelArranger()
    {
        return $this->IsTravelArranger;
    }
    /**
     * Set IsTravelArranger value
     * @param bool $isTravelArranger
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsTravelArranger($isTravelArranger = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTravelArranger) && !is_bool($isTravelArranger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTravelArranger)), __LINE__);
        }
        $this->IsTravelArranger = $isTravelArranger;
        return $this;
    }
    /**
     * Get ApproverNotRequired value
     * @return bool
     */
    public function getApproverNotRequired()
    {
        return $this->ApproverNotRequired;
    }
    /**
     * Set ApproverNotRequired value
     * @param bool $approverNotRequired
     * @return \dgsoft\StructType\DgUser
     */
    public function setApproverNotRequired($approverNotRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($approverNotRequired) && !is_bool($approverNotRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($approverNotRequired)), __LINE__);
        }
        $this->ApproverNotRequired = $approverNotRequired;
        return $this;
    }
    /**
     * Get ModifyProfile value
     * @return bool
     */
    public function getModifyProfile()
    {
        return $this->ModifyProfile;
    }
    /**
     * Set ModifyProfile value
     * @param bool $modifyProfile
     * @return \dgsoft\StructType\DgUser
     */
    public function setModifyProfile($modifyProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyProfile) && !is_bool($modifyProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($modifyProfile)), __LINE__);
        }
        $this->ModifyProfile = $modifyProfile;
        return $this;
    }
    /**
     * Get IsLocked value
     * @return bool
     */
    public function getIsLocked()
    {
        return $this->IsLocked;
    }
    /**
     * Set IsLocked value
     * @param bool $isLocked
     * @return \dgsoft\StructType\DgUser
     */
    public function setIsLocked($isLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLocked) && !is_bool($isLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isLocked)), __LINE__);
        }
        $this->IsLocked = $isLocked;
        return $this;
    }
    /**
     * Get AllowToAccessCorpReports value
     * @return bool
     */
    public function getAllowToAccessCorpReports()
    {
        return $this->AllowToAccessCorpReports;
    }
    /**
     * Set AllowToAccessCorpReports value
     * @param bool $allowToAccessCorpReports
     * @return \dgsoft\StructType\DgUser
     */
    public function setAllowToAccessCorpReports($allowToAccessCorpReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowToAccessCorpReports) && !is_bool($allowToAccessCorpReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowToAccessCorpReports)), __LINE__);
        }
        $this->AllowToAccessCorpReports = $allowToAccessCorpReports;
        return $this;
    }
    /**
     * Get PRDADMIN value
     * @return bool
     */
    public function getPRDADMIN()
    {
        return $this->PRDADMIN;
    }
    /**
     * Set PRDADMIN value
     * @param bool $pRDADMIN
     * @return \dgsoft\StructType\DgUser
     */
    public function setPRDADMIN($pRDADMIN = null)
    {
        // validation for constraint: boolean
        if (!is_null($pRDADMIN) && !is_bool($pRDADMIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pRDADMIN)), __LINE__);
        }
        $this->PRDADMIN = $pRDADMIN;
        return $this;
    }
    /**
     * Get UICustRights value
     * @return string
     */
    public function getUICustRights()
    {
        return $this->UICustRights;
    }
    /**
     * Set UICustRights value
     * @uses \dgsoft\EnumType\DgUICustomizationsRights::valueIsValid()
     * @uses \dgsoft\EnumType\DgUICustomizationsRights::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uICustRights
     * @return \dgsoft\StructType\DgUser
     */
    public function setUICustRights($uICustRights = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgUICustomizationsRights::valueIsValid($uICustRights)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $uICustRights, implode(', ', \dgsoft\EnumType\DgUICustomizationsRights::getValidValues())), __LINE__);
        }
        $this->UICustRights = $uICustRights;
        return $this;
    }
    /**
     * Get UIMigrationUser value
     * @return bool
     */
    public function getUIMigrationUser()
    {
        return $this->UIMigrationUser;
    }
    /**
     * Set UIMigrationUser value
     * @param bool $uIMigrationUser
     * @return \dgsoft\StructType\DgUser
     */
    public function setUIMigrationUser($uIMigrationUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($uIMigrationUser) && !is_bool($uIMigrationUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($uIMigrationUser)), __LINE__);
        }
        $this->UIMigrationUser = $uIMigrationUser;
        return $this;
    }
    /**
     * Get LogID value
     * @return string
     */
    public function getLogID()
    {
        return $this->LogID;
    }
    /**
     * Set LogID value
     * @param string $logID
     * @return \dgsoft\StructType\DgUser
     */
    public function setLogID($logID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($logID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $logID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($logID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($logID) && !is_string($logID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logID)), __LINE__);
        }
        $this->LogID = $logID;
        return $this;
    }
    /**
     * Get ExtraProperties value
     * @return \dgsoft\ArrayType\DgArrayOfNameValueTypeItem|null
     */
    public function getExtraProperties()
    {
        return $this->ExtraProperties;
    }
    /**
     * Set ExtraProperties value
     * @param \dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraProperties
     * @return \dgsoft\StructType\DgUser
     */
    public function setExtraProperties(\dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraProperties = null)
    {
        $this->ExtraProperties = $extraProperties;
        return $this;
    }
    /**
     * Get ExtraSettings value
     * @return \dgsoft\ArrayType\DgArrayOfNameValueTypeItem|null
     */
    public function getExtraSettings()
    {
        return $this->ExtraSettings;
    }
    /**
     * Set ExtraSettings value
     * @param \dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraSettings
     * @return \dgsoft\StructType\DgUser
     */
    public function setExtraSettings(\dgsoft\ArrayType\DgArrayOfNameValueTypeItem $extraSettings = null)
    {
        $this->ExtraSettings = $extraSettings;
        return $this;
    }
    /**
     * Get GuestUserId value
     * @return string|null
     */
    public function getGuestUserId()
    {
        return $this->GuestUserId;
    }
    /**
     * Set GuestUserId value
     * @param string $guestUserId
     * @return \dgsoft\StructType\DgUser
     */
    public function setGuestUserId($guestUserId = null)
    {
        // validation for constraint: string
        if (!is_null($guestUserId) && !is_string($guestUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guestUserId)), __LINE__);
        }
        $this->GuestUserId = $guestUserId;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \dgsoft\StructType\DgUser
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \dgsoft\StructType\DgUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get HashedPassword value
     * @return string|null
     */
    public function getHashedPassword()
    {
        return $this->HashedPassword;
    }
    /**
     * Set HashedPassword value
     * @param string $hashedPassword
     * @return \dgsoft\StructType\DgUser
     */
    public function setHashedPassword($hashedPassword = null)
    {
        // validation for constraint: string
        if (!is_null($hashedPassword) && !is_string($hashedPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hashedPassword)), __LINE__);
        }
        $this->HashedPassword = $hashedPassword;
        return $this;
    }
    /**
     * Get Salt value
     * @return string|null
     */
    public function getSalt()
    {
        return $this->Salt;
    }
    /**
     * Set Salt value
     * @param string $salt
     * @return \dgsoft\StructType\DgUser
     */
    public function setSalt($salt = null)
    {
        // validation for constraint: string
        if (!is_null($salt) && !is_string($salt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salt)), __LINE__);
        }
        $this->Salt = $salt;
        return $this;
    }
    /**
     * Get PasswordAnswer value
     * @return string|null
     */
    public function getPasswordAnswer()
    {
        return $this->PasswordAnswer;
    }
    /**
     * Set PasswordAnswer value
     * @param string $passwordAnswer
     * @return \dgsoft\StructType\DgUser
     */
    public function setPasswordAnswer($passwordAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($passwordAnswer) && !is_string($passwordAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordAnswer)), __LINE__);
        }
        $this->PasswordAnswer = $passwordAnswer;
        return $this;
    }
    /**
     * Get HashedPasswordAnswer value
     * @return string|null
     */
    public function getHashedPasswordAnswer()
    {
        return $this->HashedPasswordAnswer;
    }
    /**
     * Set HashedPasswordAnswer value
     * @param string $hashedPasswordAnswer
     * @return \dgsoft\StructType\DgUser
     */
    public function setHashedPasswordAnswer($hashedPasswordAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($hashedPasswordAnswer) && !is_string($hashedPasswordAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hashedPasswordAnswer)), __LINE__);
        }
        $this->HashedPasswordAnswer = $hashedPasswordAnswer;
        return $this;
    }
    /**
     * Get PasswordQuestion value
     * @return string|null
     */
    public function getPasswordQuestion()
    {
        return $this->PasswordQuestion;
    }
    /**
     * Set PasswordQuestion value
     * @param string $passwordQuestion
     * @return \dgsoft\StructType\DgUser
     */
    public function setPasswordQuestion($passwordQuestion = null)
    {
        // validation for constraint: string
        if (!is_null($passwordQuestion) && !is_string($passwordQuestion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordQuestion)), __LINE__);
        }
        $this->PasswordQuestion = $passwordQuestion;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \dgsoft\StructType\DgUser
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Passengers value
     * @return \dgsoft\ArrayType\DgArrayOfPassengerDB|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @param \dgsoft\ArrayType\DgArrayOfPassengerDB $passengers
     * @return \dgsoft\StructType\DgUser
     */
    public function setPassengers(\dgsoft\ArrayType\DgArrayOfPassengerDB $passengers = null)
    {
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Get UserCulture value
     * @return string|null
     */
    public function getUserCulture()
    {
        return $this->UserCulture;
    }
    /**
     * Set UserCulture value
     * @param string $userCulture
     * @return \dgsoft\StructType\DgUser
     */
    public function setUserCulture($userCulture = null)
    {
        // validation for constraint: string
        if (!is_null($userCulture) && !is_string($userCulture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userCulture)), __LINE__);
        }
        $this->UserCulture = $userCulture;
        return $this;
    }
    /**
     * Get AccountAmountCurrency value
     * @return string|null
     */
    public function getAccountAmountCurrency()
    {
        return $this->AccountAmountCurrency;
    }
    /**
     * Set AccountAmountCurrency value
     * @param string $accountAmountCurrency
     * @return \dgsoft\StructType\DgUser
     */
    public function setAccountAmountCurrency($accountAmountCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($accountAmountCurrency) && !is_string($accountAmountCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountAmountCurrency)), __LINE__);
        }
        $this->AccountAmountCurrency = $accountAmountCurrency;
        return $this;
    }
    /**
     * Get Tolerance value
     * @return string|null
     */
    public function getTolerance()
    {
        return $this->Tolerance;
    }
    /**
     * Set Tolerance value
     * @param string $tolerance
     * @return \dgsoft\StructType\DgUser
     */
    public function setTolerance($tolerance = null)
    {
        // validation for constraint: string
        if (!is_null($tolerance) && !is_string($tolerance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tolerance)), __LINE__);
        }
        $this->Tolerance = $tolerance;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \dgsoft\StructType\DgPerson|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @param \dgsoft\StructType\DgPerson $contactPerson
     * @return \dgsoft\StructType\DgUser
     */
    public function setContactPerson(\dgsoft\StructType\DgPerson $contactPerson = null)
    {
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get UserCorporate value
     * @return \dgsoft\StructType\DgCorporate|null
     */
    public function getUserCorporate()
    {
        return $this->UserCorporate;
    }
    /**
     * Set UserCorporate value
     * @param \dgsoft\StructType\DgCorporate $userCorporate
     * @return \dgsoft\StructType\DgUser
     */
    public function setUserCorporate(\dgsoft\StructType\DgCorporate $userCorporate = null)
    {
        $this->UserCorporate = $userCorporate;
        return $this;
    }
    /**
     * Get TravelApprovers value
     * @return \dgsoft\ArrayType\DgArrayOfUser|null
     */
    public function getTravelApprovers()
    {
        return $this->TravelApprovers;
    }
    /**
     * Set TravelApprovers value
     * @param \dgsoft\ArrayType\DgArrayOfUser $travelApprovers
     * @return \dgsoft\StructType\DgUser
     */
    public function setTravelApprovers(\dgsoft\ArrayType\DgArrayOfUser $travelApprovers = null)
    {
        $this->TravelApprovers = $travelApprovers;
        return $this;
    }
    /**
     * Get TravelArrangers value
     * @return \dgsoft\ArrayType\DgArrayOfUser|null
     */
    public function getTravelArrangers()
    {
        return $this->TravelArrangers;
    }
    /**
     * Set TravelArrangers value
     * @param \dgsoft\ArrayType\DgArrayOfUser $travelArrangers
     * @return \dgsoft\StructType\DgUser
     */
    public function setTravelArrangers(\dgsoft\ArrayType\DgArrayOfUser $travelArrangers = null)
    {
        $this->TravelArrangers = $travelArrangers;
        return $this;
    }
    /**
     * Get BookingAllow value
     * @return string|null
     */
    public function getBookingAllow()
    {
        return $this->BookingAllow;
    }
    /**
     * Set BookingAllow value
     * @param string $bookingAllow
     * @return \dgsoft\StructType\DgUser
     */
    public function setBookingAllow($bookingAllow = null)
    {
        // validation for constraint: string
        if (!is_null($bookingAllow) && !is_string($bookingAllow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingAllow)), __LINE__);
        }
        $this->BookingAllow = $bookingAllow;
        return $this;
    }
    /**
     * Get OPSProfile value
     * @return \dgsoft\StructType\DgOPSProfile|null
     */
    public function getOPSProfile()
    {
        return $this->OPSProfile;
    }
    /**
     * Set OPSProfile value
     * @param \dgsoft\StructType\DgOPSProfile $oPSProfile
     * @return \dgsoft\StructType\DgUser
     */
    public function setOPSProfile(\dgsoft\StructType\DgOPSProfile $oPSProfile = null)
    {
        $this->OPSProfile = $oPSProfile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
