<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInformationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTravelerInformationType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerTypeQuantityType[]
     */
    public $PassengerTypeQuantity;
    /**
     * The AirTraveler
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirTravelerType
     */
    public $AirTraveler;
    /**
     * Constructor method for TravelerInformationType
     * @uses DgTravelerInformationType::setPassengerTypeQuantity()
     * @uses DgTravelerInformationType::setAirTraveler()
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType[] $passengerTypeQuantity
     * @param \dgsoft\StructType\DgAirTravelerType $airTraveler
     */
    public function __construct(array $passengerTypeQuantity = array(), \dgsoft\StructType\DgAirTravelerType $airTraveler = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setAirTraveler($airTraveler);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType[]|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType[] $passengerTypeQuantity
     * @return \dgsoft\StructType\DgTravelerInformationType
     */
    public function setPassengerTypeQuantity(array $passengerTypeQuantity = array())
    {
        foreach ($passengerTypeQuantity as $travelerInformationTypePassengerTypeQuantityItem) {
            // validation for constraint: itemType
            if (!$travelerInformationTypePassengerTypeQuantityItem instanceof \dgsoft\StructType\DgPassengerTypeQuantityType) {
                throw new \InvalidArgumentException(sprintf('The PassengerTypeQuantity property can only contain items of \dgsoft\StructType\DgPassengerTypeQuantityType, "%s" given', is_object($travelerInformationTypePassengerTypeQuantityItem) ? get_class($travelerInformationTypePassengerTypeQuantityItem) : gettype($travelerInformationTypePassengerTypeQuantityItem)), __LINE__);
            }
        }
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Add item to PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $item
     * @return \dgsoft\StructType\DgTravelerInformationType
     */
    public function addToPassengerTypeQuantity(\dgsoft\StructType\DgPassengerTypeQuantityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPassengerTypeQuantityType) {
            throw new \InvalidArgumentException(sprintf('The PassengerTypeQuantity property can only contain items of \dgsoft\StructType\DgPassengerTypeQuantityType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PassengerTypeQuantity[] = $item;
        return $this;
    }
    /**
     * Get AirTraveler value
     * @return \dgsoft\StructType\DgAirTravelerType|null
     */
    public function getAirTraveler()
    {
        return $this->AirTraveler;
    }
    /**
     * Set AirTraveler value
     * @param \dgsoft\StructType\DgAirTravelerType $airTraveler
     * @return \dgsoft\StructType\DgTravelerInformationType
     */
    public function setAirTraveler(\dgsoft\StructType\DgAirTravelerType $airTraveler = null)
    {
        $this->AirTraveler = $airTraveler;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTravelerInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
