<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTravelerInfoType extends AbstractStructBase
{
    /**
     * The AirTraveler
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirTraveler[]
     */
    public $AirTraveler;
    /**
     * The SpecialReqDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecialReqDetailsType[]
     */
    public $SpecialReqDetails;
    /**
     * Constructor method for TravelerInfoType
     * @uses DgTravelerInfoType::setAirTraveler()
     * @uses DgTravelerInfoType::setSpecialReqDetails()
     * @param \dgsoft\StructType\DgAirTraveler[] $airTraveler
     * @param \dgsoft\StructType\DgSpecialReqDetailsType[] $specialReqDetails
     */
    public function __construct(array $airTraveler = array(), array $specialReqDetails = array())
    {
        $this
            ->setAirTraveler($airTraveler)
            ->setSpecialReqDetails($specialReqDetails);
    }
    /**
     * Get AirTraveler value
     * @return \dgsoft\StructType\DgAirTraveler[]|null
     */
    public function getAirTraveler()
    {
        return $this->AirTraveler;
    }
    /**
     * Set AirTraveler value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirTraveler[] $airTraveler
     * @return \dgsoft\StructType\DgTravelerInfoType
     */
    public function setAirTraveler(array $airTraveler = array())
    {
        foreach ($airTraveler as $travelerInfoTypeAirTravelerItem) {
            // validation for constraint: itemType
            if (!$travelerInfoTypeAirTravelerItem instanceof \dgsoft\StructType\DgAirTraveler) {
                throw new \InvalidArgumentException(sprintf('The AirTraveler property can only contain items of \dgsoft\StructType\DgAirTraveler, "%s" given', is_object($travelerInfoTypeAirTravelerItem) ? get_class($travelerInfoTypeAirTravelerItem) : gettype($travelerInfoTypeAirTravelerItem)), __LINE__);
            }
        }
        $this->AirTraveler = $airTraveler;
        return $this;
    }
    /**
     * Add item to AirTraveler value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirTraveler $item
     * @return \dgsoft\StructType\DgTravelerInfoType
     */
    public function addToAirTraveler(\dgsoft\StructType\DgAirTraveler $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAirTraveler) {
            throw new \InvalidArgumentException(sprintf('The AirTraveler property can only contain items of \dgsoft\StructType\DgAirTraveler, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirTraveler[] = $item;
        return $this;
    }
    /**
     * Get SpecialReqDetails value
     * @return \dgsoft\StructType\DgSpecialReqDetailsType[]|null
     */
    public function getSpecialReqDetails()
    {
        return $this->SpecialReqDetails;
    }
    /**
     * Set SpecialReqDetails value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialReqDetailsType[] $specialReqDetails
     * @return \dgsoft\StructType\DgTravelerInfoType
     */
    public function setSpecialReqDetails(array $specialReqDetails = array())
    {
        foreach ($specialReqDetails as $travelerInfoTypeSpecialReqDetailsItem) {
            // validation for constraint: itemType
            if (!$travelerInfoTypeSpecialReqDetailsItem instanceof \dgsoft\StructType\DgSpecialReqDetailsType) {
                throw new \InvalidArgumentException(sprintf('The SpecialReqDetails property can only contain items of \dgsoft\StructType\DgSpecialReqDetailsType, "%s" given', is_object($travelerInfoTypeSpecialReqDetailsItem) ? get_class($travelerInfoTypeSpecialReqDetailsItem) : gettype($travelerInfoTypeSpecialReqDetailsItem)), __LINE__);
            }
        }
        $this->SpecialReqDetails = $specialReqDetails;
        return $this;
    }
    /**
     * Add item to SpecialReqDetails value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialReqDetailsType $item
     * @return \dgsoft\StructType\DgTravelerInfoType
     */
    public function addToSpecialReqDetails(\dgsoft\StructType\DgSpecialReqDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecialReqDetailsType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqDetails property can only contain items of \dgsoft\StructType\DgSpecialReqDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialReqDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTravelerInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
