<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInfoSummary StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTravelerInfoSummary extends DgTravelerInfoSummaryType
{
    /**
     * The ForcePTC
     * @var bool
     */
    public $ForcePTC;
    /**
     * The FamilyCard
     * @var bool
     */
    public $FamilyCard;
    /**
     * The FamilyType
     * @var bool
     */
    public $FamilyType;
    /**
     * The FamilyDiscount
     * @var bool
     */
    public $FamilyDiscount;
    /**
     * The TicketingCountryCode
     * @var string
     */
    public $TicketingCountryCode;
    /**
     * The SpecificPTC_Indicator
     * @var bool
     */
    public $SpecificPTC_Indicator;
    /**
     * Constructor method for TravelerInfoSummary
     * @uses DgTravelerInfoSummary::setForcePTC()
     * @uses DgTravelerInfoSummary::setFamilyCard()
     * @uses DgTravelerInfoSummary::setFamilyType()
     * @uses DgTravelerInfoSummary::setFamilyDiscount()
     * @uses DgTravelerInfoSummary::setTicketingCountryCode()
     * @uses DgTravelerInfoSummary::setSpecificPTC_Indicator()
     * @param bool $forcePTC
     * @param bool $familyCard
     * @param bool $familyType
     * @param bool $familyDiscount
     * @param string $ticketingCountryCode
     * @param bool $specificPTC_Indicator
     */
    public function __construct($forcePTC = null, $familyCard = null, $familyType = null, $familyDiscount = null, $ticketingCountryCode = null, $specificPTC_Indicator = null)
    {
        $this
            ->setForcePTC($forcePTC)
            ->setFamilyCard($familyCard)
            ->setFamilyType($familyType)
            ->setFamilyDiscount($familyDiscount)
            ->setTicketingCountryCode($ticketingCountryCode)
            ->setSpecificPTC_Indicator($specificPTC_Indicator);
    }
    /**
     * Get ForcePTC value
     * @return bool|null
     */
    public function getForcePTC()
    {
        return $this->ForcePTC;
    }
    /**
     * Set ForcePTC value
     * @param bool $forcePTC
     * @return \dgsoft\StructType\DgTravelerInfoSummary
     */
    public function setForcePTC($forcePTC = null)
    {
        // validation for constraint: boolean
        if (!is_null($forcePTC) && !is_bool($forcePTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forcePTC)), __LINE__);
        }
        $this->ForcePTC = $forcePTC;
        return $this;
    }
    /**
     * Get FamilyCard value
     * @return bool|null
     */
    public function getFamilyCard()
    {
        return $this->FamilyCard;
    }
    /**
     * Set FamilyCard value
     * @param bool $familyCard
     * @return \dgsoft\StructType\DgTravelerInfoSummary
     */
    public function setFamilyCard($familyCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($familyCard) && !is_bool($familyCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($familyCard)), __LINE__);
        }
        $this->FamilyCard = $familyCard;
        return $this;
    }
    /**
     * Get FamilyType value
     * @return bool|null
     */
    public function getFamilyType()
    {
        return $this->FamilyType;
    }
    /**
     * Set FamilyType value
     * @param bool $familyType
     * @return \dgsoft\StructType\DgTravelerInfoSummary
     */
    public function setFamilyType($familyType = null)
    {
        // validation for constraint: boolean
        if (!is_null($familyType) && !is_bool($familyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($familyType)), __LINE__);
        }
        $this->FamilyType = $familyType;
        return $this;
    }
    /**
     * Get FamilyDiscount value
     * @return bool|null
     */
    public function getFamilyDiscount()
    {
        return $this->FamilyDiscount;
    }
    /**
     * Set FamilyDiscount value
     * @param bool $familyDiscount
     * @return \dgsoft\StructType\DgTravelerInfoSummary
     */
    public function setFamilyDiscount($familyDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($familyDiscount) && !is_bool($familyDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($familyDiscount)), __LINE__);
        }
        $this->FamilyDiscount = $familyDiscount;
        return $this;
    }
    /**
     * Get TicketingCountryCode value
     * @return string|null
     */
    public function getTicketingCountryCode()
    {
        return $this->TicketingCountryCode;
    }
    /**
     * Set TicketingCountryCode value
     * @param string $ticketingCountryCode
     * @return \dgsoft\StructType\DgTravelerInfoSummary
     */
    public function setTicketingCountryCode($ticketingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingCountryCode) && !is_string($ticketingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketingCountryCode)), __LINE__);
        }
        $this->TicketingCountryCode = $ticketingCountryCode;
        return $this;
    }
    /**
     * Get SpecificPTC_Indicator value
     * @return bool|null
     */
    public function getSpecificPTC_Indicator()
    {
        return $this->SpecificPTC_Indicator;
    }
    /**
     * Set SpecificPTC_Indicator value
     * @param bool $specificPTC_Indicator
     * @return \dgsoft\StructType\DgTravelerInfoSummary
     */
    public function setSpecificPTC_Indicator($specificPTC_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($specificPTC_Indicator) && !is_bool($specificPTC_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specificPTC_Indicator)), __LINE__);
        }
        $this->SpecificPTC_Indicator = $specificPTC_Indicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTravelerInfoSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
