<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transportation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTransportation extends AbstractStructBase
{
    /**
     * The MultimediaDescriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMultimediaDescriptionsType
     */
    public $MultimediaDescriptions;
    /**
     * The OperationSchedules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOperationSchedulesType
     */
    public $OperationSchedules;
    /**
     * The DescriptiveText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The NotificationRequired
     * @var string
     */
    public $NotificationRequired;
    /**
     * The TransportationCode
     * @var string
     */
    public $TransportationCode;
    /**
     * The ChargeUnit
     * @var string
     */
    public $ChargeUnit;
    /**
     * The Included
     * @var bool
     */
    public $Included;
    /**
     * The CodeDetail
     * @var string
     */
    public $CodeDetail;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The TypicalTravelTime
     * @var string
     */
    public $TypicalTravelTime;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for Transportation
     * @uses DgTransportation::setMultimediaDescriptions()
     * @uses DgTransportation::setOperationSchedules()
     * @uses DgTransportation::setDescriptiveText()
     * @uses DgTransportation::setNotificationRequired()
     * @uses DgTransportation::setTransportationCode()
     * @uses DgTransportation::setChargeUnit()
     * @uses DgTransportation::setIncluded()
     * @uses DgTransportation::setCodeDetail()
     * @uses DgTransportation::setDescription()
     * @uses DgTransportation::setTypicalTravelTime()
     * @uses DgTransportation::setAmount()
     * @uses DgTransportation::setExistsCode()
     * @uses DgTransportation::setID()
     * @uses DgTransportation::setCode()
     * @param \dgsoft\StructType\DgMultimediaDescriptionsType $multimediaDescriptions
     * @param \dgsoft\StructType\DgOperationSchedulesType $operationSchedules
     * @param string $descriptiveText
     * @param string $notificationRequired
     * @param string $transportationCode
     * @param string $chargeUnit
     * @param bool $included
     * @param string $codeDetail
     * @param string $description
     * @param string $typicalTravelTime
     * @param float $amount
     * @param string $existsCode
     * @param string $iD
     * @param string $code
     */
    public function __construct(\dgsoft\StructType\DgMultimediaDescriptionsType $multimediaDescriptions = null, \dgsoft\StructType\DgOperationSchedulesType $operationSchedules = null, $descriptiveText = null, $notificationRequired = null, $transportationCode = null, $chargeUnit = null, $included = null, $codeDetail = null, $description = null, $typicalTravelTime = null, $amount = null, $existsCode = null, $iD = null, $code = null)
    {
        $this
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setOperationSchedules($operationSchedules)
            ->setDescriptiveText($descriptiveText)
            ->setNotificationRequired($notificationRequired)
            ->setTransportationCode($transportationCode)
            ->setChargeUnit($chargeUnit)
            ->setIncluded($included)
            ->setCodeDetail($codeDetail)
            ->setDescription($description)
            ->setTypicalTravelTime($typicalTravelTime)
            ->setAmount($amount)
            ->setExistsCode($existsCode)
            ->setID($iD)
            ->setCode($code);
    }
    /**
     * Get MultimediaDescriptions value
     * @return \dgsoft\StructType\DgMultimediaDescriptionsType|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \dgsoft\StructType\DgMultimediaDescriptionsType $multimediaDescriptions
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setMultimediaDescriptions(\dgsoft\StructType\DgMultimediaDescriptionsType $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return \dgsoft\StructType\DgOperationSchedulesType|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param \dgsoft\StructType\DgOperationSchedulesType $operationSchedules
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setOperationSchedules(\dgsoft\StructType\DgOperationSchedulesType $operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get NotificationRequired value
     * @return string|null
     */
    public function getNotificationRequired()
    {
        return $this->NotificationRequired;
    }
    /**
     * Set NotificationRequired value
     * @param string $notificationRequired
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setNotificationRequired($notificationRequired = null)
    {
        // validation for constraint: string
        if (!is_null($notificationRequired) && !is_string($notificationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationRequired)), __LINE__);
        }
        $this->NotificationRequired = $notificationRequired;
        return $this;
    }
    /**
     * Get TransportationCode value
     * @return string|null
     */
    public function getTransportationCode()
    {
        return $this->TransportationCode;
    }
    /**
     * Set TransportationCode value
     * @param string $transportationCode
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setTransportationCode($transportationCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportationCode) && !is_string($transportationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportationCode)), __LINE__);
        }
        $this->TransportationCode = $transportationCode;
        return $this;
    }
    /**
     * Get ChargeUnit value
     * @return string|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param string $chargeUnit
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setChargeUnit($chargeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnit) && !is_string($chargeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeUnit)), __LINE__);
        }
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get Included value
     * @return bool|null
     */
    public function getIncluded()
    {
        return $this->Included;
    }
    /**
     * Set Included value
     * @param bool $included
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setIncluded($included = null)
    {
        // validation for constraint: boolean
        if (!is_null($included) && !is_bool($included)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($included)), __LINE__);
        }
        $this->Included = $included;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TypicalTravelTime value
     * @return string|null
     */
    public function getTypicalTravelTime()
    {
        return $this->TypicalTravelTime;
    }
    /**
     * Set TypicalTravelTime value
     * @param string $typicalTravelTime
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setTypicalTravelTime($typicalTravelTime = null)
    {
        // validation for constraint: string
        if (!is_null($typicalTravelTime) && !is_string($typicalTravelTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typicalTravelTime)), __LINE__);
        }
        $this->TypicalTravelTime = $typicalTravelTime;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgTransportation
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTransportation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
